{ This unit defines the structure of the model. There are four functions. The
  first function, called counts, defines the number, names, and units of the
  model, the state variables, the process variables, the driver variables and
  the parameters. The second function, called processes, is the actual equations
  which make up the model. The third function, derivs, calculates the
  derivatives of state variables. And the fourth function, parcount, is used to
  automatically number the parameters consecutively. 
    The state variables, driver variables, process variables and parameters are
  all stored in global arrays, called stat, drive, proc, and par, respectively.
  The function counts accesses the global arrays directly but the other functions
  operate on copies of the global arrays. }
unit equations;

interface

uses  stypes, math;

PROCEDURE counts;
PROCEDURE processes(time:double; dtime:double; var tdrive:drivearray;
                       var tpar:paramarray; var tstat:statearray;
                       var tproc:processarray; CalculateDiscrete:Boolean);
PROCEDURE derivs(t, drt:double; var tdrive:drivearray; var tpar:paramarray;
             var statevalue:yValueArray; VAR dydt:yValueArray);
function ParCount(processnum:integer) : integer;

var
  tproc:processarray;
  tstat:statearray;
  sensflag:boolean;
  newyear:Boolean = false;

implementation

uses frontend, calculate, options;

           { Do not make modifcations above this line. }
{*****************************************************************************}

{ This procedure defines the model. The number of parameters, state, driver and
  process variables are all set in this procedure. The model name, version
  number and time unit are also set here. This procedure accesses the global
  arrays containing the the parameters, state, driver and process variables and
  the global structure ModelDef directly, to save memory space. }
PROCEDURE counts;
var
 i,npar,CurrentProc:integer;
begin
{ Set the modelname, version and time unit. }
ModelDef.modelname := 'MEL2005 Daily 4 layers';
ModelDef.versionnumber := '3.13';
ModelDef.timeunit := 'days';
ModelDef.contactperson := 'Ed/Karin/Bonnie';
ModelDef.contactaddress1 := 'Ecosystems Center';
ModelDef.contactaddress2 := 'MBL';
ModelDef.contactaddress3 := 'Woods Hole, MA 02536';

{ Set the number of state variables in the model. The maximum number of state
  variables is maxstate, in unit stypes. }
ModelDef.numstate := 74;

{ Enter the name, units and symbol for each state variable. The maximum length
  of the state variable name is 17 characters and the maximum length for units
  and symbol is stringlength (specified in unit stypes) characters. }
 
 
with stat[1] do
 begin
    name:='*N: NH4 Inorganic1';  units:='g N m-2';  symbol:='Enh4[1]';
 end;
 
with stat[2] do
 begin
    name:='*N: NH4 Inorganic2';  units:='g N m-2';  symbol:='Enh4[2]';
 end;
 
with stat[3] do
 begin
    name:='*N: NH4 Inorganic3';  units:='g N m-2';  symbol:='Enh4[3]';
 end;
 
with stat[4] do
 begin
    name:='*N: NH4 Inorganic4';  units:='g N m-2';  symbol:='Enh4[4]';
 end;
 
with stat[5] do
 begin
    name:='*N: NO3 Inorganic1';  units:='g N m-2';  symbol:='Eno3[1]';
 end;
 
with stat[6] do
 begin
    name:='*N: NO3 Inorganic2';  units:='g N m-2';  symbol:='Eno3[2]';
 end;
 
with stat[7] do
 begin
    name:='*N: NO3 Inorganic3';  units:='g N m-2';  symbol:='Eno3[3]';
 end;
 
with stat[8] do
 begin
    name:='*N: NO3 Inorganic4';  units:='g N m-2';  symbol:='Eno3[4]';
 end;
 
with stat[9] do
 begin
    name:='C: Biomass';  units:='g C m-2';  symbol:='Bc';
 end;
 
with stat[10] do
 begin
    name:='N: Biomass';  units:='g N m-2';  symbol:='Bn';
 end;
 
with stat[11] do
 begin
    name:='*C: Detrital1';  units:='g C m-2';  symbol:='Dc[1]';
 end;
 
with stat[12] do
 begin
    name:='*C: Detrital2';  units:='g C m-2';  symbol:='Dc[2]';
 end;
 
with stat[13] do
 begin
    name:='*C: Detrital3';  units:='g C m-2';  symbol:='Dc[3]';
 end;
 
with stat[14] do
 begin
    name:='*C: Detrital4';  units:='g C m-2';  symbol:='Dc[4]';
 end;
 
with stat[15] do
 begin
    name:='*N: Detrital1';  units:='g N m-2';  symbol:='Dn[1]';
 end;
 
with stat[16] do
 begin
    name:='*N: Detrital2';  units:='g N m-2';  symbol:='Dn[2]';
 end;
 
with stat[17] do
 begin
    name:='*N: Detrital3';  units:='g N m-2';  symbol:='Dn[3]';
 end;
 
with stat[18] do
 begin
    name:='*N: Detrital4';  units:='g N m-2';  symbol:='Dn[4]';
 end;
 
with stat[19] do
 begin
    name:='C: Effort';  units:='unitless';  symbol:='Vc';
 end;
 
with stat[20] do
 begin
    name:='N: Effort';  units:='unitless';  symbol:='Vn';
 end;
 
with stat[21] do
 begin
    name:='N: Mean Un cost';  units:='g C-1 g N';  symbol:='mrNup';
 end;
 
with stat[22] do
 begin
    name:='Julian Day';  units:='day';  symbol:='Jday';
 end;
 
with stat[23] do
 begin
    name:='Degree Day';  units:='deg C';  symbol:='Dday';
 end;
 
with stat[24] do
 begin
    name:='Cum GPP';  units:='g C m-2 yr-1';  symbol:='CumUcv';
 end;
 
with stat[25] do
 begin
    name:='Cum Plant Resp';  units:='g C m-2 yr-1';  symbol:='CumRcv';
 end;
 
with stat[26] do
 begin
    name:='Cum Plant Active Resp';  units:='g C m-2 yr-1';  symbol:='CumRcva';
 end;
 
with stat[27] do
 begin
    name:='Cum Plant Wood Resp';  units:='g C m-2 yr-1';  symbol:='CumRcvw';
 end;
 
with stat[28] do
 begin
    name:='Cum Litter C';  units:='g C m-2 yr-1';  symbol:='CumLcv';
 end;
 
with stat[29] do
 begin
    name:='Cum N Inputs Air';  units:='g N m-2 yr-1';  symbol:='CumRNe';
 end;
 
with stat[30] do
 begin
    name:='Cum NH4 Inputs Air';  units:='g N m-2 yr-1';  symbol:='CumRnh4e';
 end;
 
with stat[31] do
 begin
    name:='Cum NO3 Inputs Air';  units:='g N m-2 yr-1';  symbol:='CumRno3e';
 end;
 
with stat[32] do
 begin
    name:='Cum N Inputs Air+Upslop';  units:='g N m-2 yr-1';  symbol:='CumRN';
 end;
 
with stat[33] do
 begin
    name:='Cum Litter N';  units:='g N m-2 yr-1';  symbol:='CumLnv';
 end;
 
with stat[34] do
 begin
    name:='Cum NH4 Uptake';  units:='g N m-2 yr-1';  symbol:='CumUnh4v';
 end;
 
with stat[35] do
 begin
    name:='Cum NO3 Uptake';  units:='g N m-2 yr-1';  symbol:='CumUno3v';
 end;
 
with stat[36] do
 begin
    name:='Cum N Uptake';  units:='g N m-2 yr-1';  symbol:='CumUnv';
 end;
 
with stat[37] do
 begin
    name:='Cum NH4 Loss downslope';  units:='g N m-2 yr-1';  symbol:='CumLnh4d';
 end;
 
with stat[38] do
 begin
    name:='Cum NO3 Loss downslope';  units:='g N m-2 yr-1';  symbol:='CumLno3d';
 end;
 
with stat[39] do
 begin
    name:='Cum NH4 Loss channel';  units:='g N m-2 yr-1';  symbol:='CumLnh4c';
 end;
 
with stat[40] do
 begin
    name:='Cum NO3 Loss channel';  units:='g N m-2 yr-1';  symbol:='CumLno3c';
 end;
 
with stat[41] do
 begin
    name:='Cum Gross Mineralizatio';  units:='g N m-2 yr-1';  symbol:='CumRnm';
 end;
 
with stat[42] do
 begin
    name:='Cum NH4 Immobilization';  units:='g N m-2 yr-1';  symbol:='CumUnh4m';
 end;
 
with stat[43] do
 begin
    name:='Cum NO3 Immobilization';  units:='g N m-2 yr-1';  symbol:='CumUno3m';
 end;
 
with stat[44] do
 begin
    name:='Cum Tot Immobilization';  units:='g N m-2 yr-1';  symbol:='CumUnm';
 end;
 
with stat[45] do
 begin
    name:='Cum Net N Min';  units:='g N m-2 yr-1';  symbol:='CumNNmin';
 end;
 
with stat[46] do
 begin
    name:='Cum Soil Resp';  units:='g C m-2 yr-1';  symbol:='CumRcm';
 end;
 
with stat[47] do
 begin
    name:='Cum N fixation';  units:='g N m-2 yr-1';  symbol:='CumNfix';
 end;
 
with stat[48] do
 begin
    name:='Cum Litt C Evergreen';  units:='g C m-2 yr-1';  symbol:='CumLcve';
 end;
 
with stat[49] do
 begin
    name:='Cum Litt C Deciduous';  units:='g C m-2 yr-1';  symbol:='CumLcvd';
 end;
 
with stat[50] do
 begin
    name:='Cum Litt C Total foliag';  units:='g C m-2 yr-1';  symbol:='CumLcvf';
 end;
 
with stat[51] do
 begin
    name:='Cum Litt C Total root';  units:='g C m-2 yr-1';  symbol:='CumLcvr';
 end;
 
with stat[52] do
 begin
    name:='Cum Litt C Total active';  units:='g C m-2 yr-1';  symbol:='CumLcva';
 end;
 
with stat[53] do
 begin
    name:='Cum Litt C Total wood';  units:='g C m-2 yr-1';  symbol:='CumLcvw';
 end;
 
with stat[54] do
 begin
    name:='Cum Litt N Evergreen';  units:='g N m-2 yr-1';  symbol:='CumLnve';
 end;
 
with stat[55] do
 begin
    name:='Cum Litt N Deciduous';  units:='g N m-2 yr-1';  symbol:='CumLnvd';
 end;
 
with stat[56] do
 begin
    name:='Cum Litt N Total foliag';  units:='g N m-2 yr-1';  symbol:='CumLnvf';
 end;
 
with stat[57] do
 begin
    name:='Cum Litt N Total root';  units:='g N m-2 yr-1';  symbol:='CumLnvr';
 end;
 
with stat[58] do
 begin
    name:='Cum Litt N Total active';  units:='g N m-2 yr-1';  symbol:='CumLnva';
 end;
 
with stat[59] do
 begin
    name:='Cum Litt N Total wood';  units:='g N m-2 yr-1';  symbol:='CumLnvw';
 end;
 
with stat[60] do
 begin
    name:='Cum DOC loss downslope';  units:='g C m-2 yr-1';  symbol:='CumLdocd';
 end;
 
with stat[61] do
 begin
    name:='Cum DON loss downslope';  units:='g N m-2 yr-1';  symbol:='CumLdond';
 end;
 
with stat[62] do
 begin
    name:='Cum DOC loss channel';  units:='g C m-2 yr-1';  symbol:='CumLdocc';
 end;
 
with stat[63] do
 begin
    name:='Cum DON loss channel';  units:='g N m-2 yr-1';  symbol:='CumLdonc';
 end;
 
with stat[64] do
 begin
    name:='Cum DOC loss total';  units:='g C m-2 yr-1';  symbol:='CumLdoc';
 end;
 
with stat[65] do
 begin
    name:='Cum DON loss total';  units:='g N m-2 yr-1';  symbol:='CumLdon';
 end;
 
with stat[66] do
 begin
    name:='Cum tot N loss downslop';  units:='g N m-2 yr-1';  symbol:='CumLnd';
 end;
 
with stat[67] do
 begin
    name:='Cum tot N loss channel';  units:='g N m-2 yr-1';  symbol:='CumLnc';
 end;
 
with stat[68] do
 begin
    name:='Cum tot N loss aq+denit';  units:='g N m-2 yr-1';  symbol:='CumLnt';
 end;
 
with stat[69] do
 begin
    name:='Cum Nitrification';  units:='g N m-2 yr-1';  symbol:='CumLnitr';
 end;
 
with stat[70] do
 begin
    name:='Cum Denitrification';  units:='g N m-2 yr-1';  symbol:='CumLdenit';
 end;
 
with stat[71] do
 begin
    name:='Cum NPP';  units:='g C m-2 yr-1';  symbol:='CumNPP';
 end;
 
with stat[72] do
 begin
    name:='Cum NEP';  units:='g C m-2 yr-1';  symbol:='CumNEP';
 end;
 
with stat[73] do
 begin
    name:='Cum NH4 Loss total';  units:='g N m-2 yr-1';  symbol:='CumLnh4';
 end;
 
with stat[74] do
 begin
    name:='Cum NO3 Loss total';  units:='g N m-2 yr-1';  symbol:='CumLno3';
 end;

{ Set the total number of processes in the model. The first numstate processes
  are the derivatives of the state variables. The maximum number of processes is
  maxparam, in unit stypes. }
ModelDef.numprocess := ModelDef.numstate + 213;

{ For each process, set proc[i].parameters equal to the number of parameters
  associated with that process, and set IsDiscrete to true or false. After each
  process, set the name, units, and symbol for all parameters associated with
  that process. Note that Parcount returns the total number of parameters in
  all previous processes. }
 
CurrentProc := ModelDef.numstate + 1;
With proc[CurrentProc] do
   begin
      name       := 'Average daily air temp';
      units       := 'deg C';
      symbol       := 'Ta';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 2;
With proc[CurrentProc] do
   begin
      name       := 'Daily canopy fraction';
      units       := 'unitless';
      symbol       := 'fc';
      parameters       := 1;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Minimum canopy fraction';  units:='unitless';  symbol:='fcmin';
 end;
 
CurrentProc := ModelDef.numstate + 3;
With proc[CurrentProc] do
   begin
      name       := 'Season Length';
      units       := 'none';
      symbol       := 'dum3';
      parameters       := 4;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Julian day start Dday count';  units:='day';  symbol:='Jdegstart';
 end;
with par[npar + 2] do
 begin
    name:='Degree Day bud break';  units:='deg C';  symbol:='Ddbud';
 end;
with par[npar + 3] do
 begin
    name:='Degree Day full canopy';  units:='deg C';  symbol:='Ddfull';
 end;
with par[npar + 4] do
 begin
    name:='mrNup adjustment rate';  units:='day-1';  symbol:='tau';
 end;
 
CurrentProc := ModelDef.numstate + 4;
With proc[CurrentProc] do
   begin
      name       := 'C Active Tissue';
      units       := 'g C m-2';
      symbol       := 'Ba';
      parameters       := 2;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Maximum active tissue';  units:='g C m-2';  symbol:='Bamax';
 end;
with par[npar + 2] do
 begin
    name:='Allometric parameter';  units:='none';  symbol:='c';
 end;
 
CurrentProc := ModelDef.numstate + 5;
With proc[CurrentProc] do
   begin
      name       := 'C:N Optimal Veg';
      units       := 'g C g N';
      symbol       := 'q';
      parameters       := 4;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Minimum C:N';  units:='g C g-1 N';  symbol:='qmin';
 end;
with par[npar + 2] do
 begin
    name:='Maximum C:N';  units:='g C g-1 N';  symbol:='qmax';
 end;
with par[npar + 3] do
 begin
    name:='Active tissue C:N';  units:='g C g-1 N';  symbol:='qa';
 end;
with par[npar + 4] do
 begin
    name:='Wood C:N';  units:='g C g-1 N';  symbol:='qw';
 end;
 
CurrentProc := ModelDef.numstate + 6;
With proc[CurrentProc] do
   begin
      name       := 'Leaf Area';
      units       := 'm2 m-2';
      symbol       := 'Sc';
      parameters       := 1;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Leaf area per unit C';  units:='m2 g-1 C';  symbol:='bbc';
 end;
 
CurrentProc := ModelDef.numstate + 7;
With proc[CurrentProc] do
   begin
      name       := 'Root Length';
      units       := 'm m-2';
      symbol       := 'Sn';
      parameters       := 1;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Root length per unit C';  units:='m g-1 C';  symbol:='bbn';
 end;
 
CurrentProc := ModelDef.numstate + 8;
With proc[CurrentProc] do
   begin
      name       := 'C Growth Sub Corrected';
      units       := 'g C m-2 day-1';
      symbol       := 'GC';
      parameters       := 2;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Canopy quantum yield';  units:='g C MJ-1';  symbol:='ggc';
 end;
with par[npar + 2] do
 begin
    name:='CO2 half sat';  units:='ml m-3';  symbol:='kc';
 end;
 
CurrentProc := ModelDef.numstate + 9;
With proc[CurrentProc] do
   begin
      name       := 'N NH4 Growth Sub Correc';
      units       := 'g N m-2 day-1';
      symbol       := 'Gnh4';
      parameters       := 2;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max plant NH4 uptake';  units:='g N m-2 day-1';  symbol:='ggnh4';
 end;
with par[npar + 2] do
 begin
    name:='Inorg N half sat';  units:='umol N L-1 H2O';  symbol:='knh4';
 end;
 
CurrentProc := ModelDef.numstate + 10;
With proc[CurrentProc] do
   begin
      name       := 'N NO3 Growth Sub Correc';
      units       := 'g N m-2 day-1';
      symbol       := 'Gno3';
      parameters       := 2;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max plant NO3 uptake';  units:='g N m-2 day-1';  symbol:='ggno3';
 end;
with par[npar + 2] do
 begin
    name:='Inorg N half sat';  units:='umol N L-1 H2O';  symbol:='kno3';
 end;
 
CurrentProc := ModelDef.numstate + 11;
With proc[CurrentProc] do
   begin
      name       := 'Gross Photosynthesis';
      units       := 'g C m-2 day-1';
      symbol       := 'UCv';
      parameters       := 1;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Light Extinction Coeff';  units:='m2 m-2';  symbol:='ki';
 end;
 
CurrentProc := ModelDef.numstate + 12;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Plant Uptake1';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4v[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 13;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Plant Uptake2';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4v[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 14;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Plant Uptake3';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4v[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 15;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Plant Uptake4';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4v[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 16;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Plant Uptake1';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3v[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 17;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Plant Uptake2';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3v[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 18;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Plant Uptake3';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3v[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 19;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Plant Uptake4';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3v[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 20;
With proc[CurrentProc] do
   begin
      name       := 'N Ntot Plant Uptake';
      units       := 'g N m-2 day-1';
      symbol       := 'UNv';
      parameters       := 1;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Soil resource extinction';  units:='m2 m-1';  symbol:='ks';
 end;
 
CurrentProc := ModelDef.numstate + 21;
With proc[CurrentProc] do
   begin
      name       := 'N Uptake Cost';
      units       := 'g C g-1 N';
      symbol       := 'rNup';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 22;
With proc[CurrentProc] do
   begin
      name       := 'N fixation';
      units       := 'g N m-2 day-1';
      symbol       := 'Unfix';
      parameters       := 3;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='N fixation constant';  units:='g2 N g-1 C m-2 day-1';  symbol:='gnfix';
 end;
with par[npar + 2] do
 begin
    name:='N fixation cost';  units:='g C g-1 N';  symbol:='rnfix';
 end;
with par[npar + 3] do
 begin
    name:='N fix cost half saturation';  units:='g C g-1 N';  symbol:='knfix';
 end;
 
CurrentProc := ModelDef.numstate + 23;
With proc[CurrentProc] do
   begin
      name       := 'Lit evergreen switch';
      units       := 'unitless';
      symbol       := 'Swle';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Evergreen Lit change rate';  units:='day-1';  symbol:='betaSle';
 end;
with par[npar + 2] do
 begin
    name:='Jday evergreen lit start';  units:='day';  symbol:='Jdestart';
 end;
with par[npar + 3] do
 begin
    name:='Jday evergreen lit stop';  units:='day';  symbol:='Jdeend';
 end;
 
CurrentProc := ModelDef.numstate + 24;
With proc[CurrentProc] do
   begin
      name       := 'Lit root switch';
      units       := 'unitless';
      symbol       := 'Swlr';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Root Lit change rate';  units:='day-1';  symbol:='betaSlr';
 end;
with par[npar + 2] do
 begin
    name:='Jday root lit start';  units:='day';  symbol:='Jdrstart';
 end;
with par[npar + 3] do
 begin
    name:='Jday root lit stop';  units:='day';  symbol:='Jdrend';
 end;
 
CurrentProc := ModelDef.numstate + 25;
With proc[CurrentProc] do
   begin
      name       := 'Lit decid switch';
      units       := 'unitless';
      symbol       := 'Swld';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decid Lit change rate';  units:='day-1';  symbol:='betaSld';
 end;
with par[npar + 2] do
 begin
    name:='Jday decid lit start';  units:='day';  symbol:='Jddstart';
 end;
with par[npar + 3] do
 begin
    name:='Jday decid lit stop';  units:='day';  symbol:='Jddend';
 end;
 
CurrentProc := ModelDef.numstate + 26;
With proc[CurrentProc] do
   begin
      name       := 'Lit wood switch';
      units       := 'unitless';
      symbol       := 'Swlw';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Wood Lit change rate';  units:='day-1';  symbol:='betaSlw';
 end;
with par[npar + 2] do
 begin
    name:='Jday wood lit start';  units:='day';  symbol:='Jdwstart';
 end;
with par[npar + 3] do
 begin
    name:='Jday wood lit stop';  units:='day';  symbol:='Jdwend';
 end;
 
CurrentProc := ModelDef.numstate + 27;
With proc[CurrentProc] do
   begin
      name       := 'Litter loss params';
      units       := 'none';
      symbol       := 'dum6';
      parameters       := 2;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Active tissue loss rate';  units:='day-1';  symbol:='ma';
 end;
with par[npar + 2] do
 begin
    name:='Wood loss rate';  units:='day-1';  symbol:='mw';
 end;
 
CurrentProc := ModelDef.numstate + 28;
With proc[CurrentProc] do
   begin
      name       := '*C litter loss1';
      units       := 'g C m-2 day-1';
      symbol       := 'LCv[1]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 29;
With proc[CurrentProc] do
   begin
      name       := '*C litter loss2';
      units       := 'g C m-2 day-1';
      symbol       := 'LCv[2]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 30;
With proc[CurrentProc] do
   begin
      name       := '*C litter loss3';
      units       := 'g C m-2 day-1';
      symbol       := 'LCv[3]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 31;
With proc[CurrentProc] do
   begin
      name       := '*C litter loss4';
      units       := 'g C m-2 day-1';
      symbol       := 'LCv[4]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 32;
With proc[CurrentProc] do
   begin
      name       := '*N litter loss1';
      units       := 'g N m-2 day-1';
      symbol       := 'LNv[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 33;
With proc[CurrentProc] do
   begin
      name       := '*N litter loss2';
      units       := 'g N m-2 day-1';
      symbol       := 'LNv[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 34;
With proc[CurrentProc] do
   begin
      name       := '*N litter loss3';
      units       := 'g N m-2 day-1';
      symbol       := 'LNv[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 35;
With proc[CurrentProc] do
   begin
      name       := '*N litter loss4';
      units       := 'g N m-2 day-1';
      symbol       := 'LNv[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 36;
With proc[CurrentProc] do
   begin
      name       := 'Plant Respiration';
      units       := 'g C m-2 day-1';
      symbol       := 'RCv';
      parameters       := 2;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Active tissue resp rate';  units:='day-1';  symbol:='ra';
 end;
with par[npar + 2] do
 begin
    name:='Wood respiration rate';  units:='day-1';  symbol:='rw';
 end;
 
CurrentProc := ModelDef.numstate + 37;
With proc[CurrentProc] do
   begin
      name       := 'Active Tissue Respirati';
      units       := 'g C m-2 day-1';
      symbol       := 'RCva';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 38;
With proc[CurrentProc] do
   begin
      name       := 'Wood Respiration';
      units       := 'g C m-2 day-1';
      symbol       := 'RCvw';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 39;
With proc[CurrentProc] do
   begin
      name       := 'Acclimation potential';
      units       := 'unitless';
      symbol       := 'A';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Acclimation rate';  units:='day-1';  symbol:='aa';
 end;
with par[npar + 2] do
 begin
    name:='Acclim damping coefficient';  units:='day';  symbol:='h';
 end;
 
CurrentProc := ModelDef.numstate + 40;
With proc[CurrentProc] do
   begin
      name       := 'Temperature Response';
      units       := 'none';
      symbol       := 'dum';
      parameters       := 6;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Carbon uptake Q10';  units:='unitless';  symbol:='Q10gc';
 end;
with par[npar + 2] do
 begin
    name:='Nitrogen uptake Q10';  units:='unitless';  symbol:='Q10gn';
 end;
with par[npar + 3] do
 begin
    name:='Active tissue Resp Q10';  units:='unitless';  symbol:='Q10ra';
 end;
with par[npar + 4] do
 begin
    name:='Woody tissue Resp Q10';  units:='unitless';  symbol:='Q10rw';
 end;
with par[npar + 5] do
 begin
    name:='Decomposition Q10';  units:='unitless';  symbol:='Q10d';
 end;
with par[npar + 6] do
 begin
    name:='Nitrogen fixation Q10';  units:='unitless';  symbol:='Q10Nfix';
 end;
 
CurrentProc := ModelDef.numstate + 41;
With proc[CurrentProc] do
   begin
      name       := 'Ucv Moisture Response';
      units       := 'unitless';
      symbol       := 'Msp';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Soil Water at Wilting';  units:='mm H2O';  symbol:='Ww';
 end;
with par[npar + 2] do
 begin
    name:='C Uptake Wr[j] sensitivity';  units:='unitless';  symbol:='bmsp';
 end;
 
CurrentProc := ModelDef.numstate + 42;
With proc[CurrentProc] do
   begin
      name       := '*Decomp Moisture Respon1';
      units       := 'unitless';
      symbol       := 'Msd[1]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 43;
With proc[CurrentProc] do
   begin
      name       := '*Decomp Moisture Respon2';
      units       := 'unitless';
      symbol       := 'Msd[2]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 44;
With proc[CurrentProc] do
   begin
      name       := '*Decomp Moisture Respon3';
      units       := 'unitless';
      symbol       := 'Msd[3]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 45;
With proc[CurrentProc] do
   begin
      name       := '*Decomp Moisture Respon4';
      units       := 'unitless';
      symbol       := 'Msd[4]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 46;
With proc[CurrentProc] do
   begin
      name       := 'Decomp Moisture Resp Pa';
      units       := 'unitless';
      symbol       := 'dum7';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decomp moisture par';  units:='unitless';  symbol:='alphaSD';
 end;
with par[npar + 2] do
 begin
    name:='Decomp Minimum Soil water';  units:='mm H2O';  symbol:='Wrmin';
 end;
with par[npar + 3] do
 begin
    name:='Decomp Optimum Soil water';  units:='mm H2O';  symbol:='Wropt';
 end;
 
CurrentProc := ModelDef.numstate + 47;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Evergreen';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcve';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 48;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Deciduous';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcvd';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 49;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Total Foliage';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcvf';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 50;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Total root';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcvr';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 51;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Total Active';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcva';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 52;
With proc[CurrentProc] do
   begin
      name       := 'Litt C Wood';
      units       := 'g C m-2 day-1';
      symbol       := 'Lcvw';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 53;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Evergreen';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnve';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 54;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Deciduous';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnvd';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 55;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Total Foliage';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnvf';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 56;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Total root';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnvr';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 57;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Total Active';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnva';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 58;
With proc[CurrentProc] do
   begin
      name       := 'Litt N Wood';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnvw';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 59;
With proc[CurrentProc] do
   begin
      name       := 'Nfixation switch';
      units       := 'none';
      symbol       := 'swNfix';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 60;
With proc[CurrentProc] do
   begin
      name       := 'C Biomass harvest';
      units       := 'g C m-2 day-1';
      symbol       := 'Hcv';
      parameters       := 2;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Julian day harvest';  units:='Julian day';  symbol:='Jdharvest';
 end;
with par[npar + 2] do
 begin
    name:='Harvest rate';  units:='day-1';  symbol:='gammaH';
 end;
 
CurrentProc := ModelDef.numstate + 61;
With proc[CurrentProc] do
   begin
      name       := 'H Biomass harvest';
      units       := 'g N m-2 day-1';
      symbol       := 'Hnv';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 62;
With proc[CurrentProc] do
   begin
      name       := '*Soil layer properties1';
      units       := 'none';
      symbol       := 'dum2[1]';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Layer thickness1';  units:='m';  symbol:='z[1]';
 end;
with par[npar + 2] do
 begin
    name:='Soil bulk density1';  units:='g m-3';  symbol:='rhos[1]';
 end;
with par[npar + 3] do
 begin
    name:='Porosity1';  units:='fraction';  symbol:='thetas[1]';
 end;
 
CurrentProc := ModelDef.numstate + 63;
With proc[CurrentProc] do
   begin
      name       := '*Soil layer properties2';
      units       := 'none';
      symbol       := 'dum2[2]';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Layer thickness2';  units:='m';  symbol:='z[2]';
 end;
with par[npar + 2] do
 begin
    name:='Soil bulk density2';  units:='g m-3';  symbol:='rhos[2]';
 end;
with par[npar + 3] do
 begin
    name:='Porosity2';  units:='fraction';  symbol:='thetas[2]';
 end;
 
CurrentProc := ModelDef.numstate + 64;
With proc[CurrentProc] do
   begin
      name       := '*Soil layer properties3';
      units       := 'none';
      symbol       := 'dum2[3]';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Layer thickness3';  units:='m';  symbol:='z[3]';
 end;
with par[npar + 2] do
 begin
    name:='Soil bulk density3';  units:='g m-3';  symbol:='rhos[3]';
 end;
with par[npar + 3] do
 begin
    name:='Porosity3';  units:='fraction';  symbol:='thetas[3]';
 end;
 
CurrentProc := ModelDef.numstate + 65;
With proc[CurrentProc] do
   begin
      name       := '*Soil layer properties4';
      units       := 'none';
      symbol       := 'dum2[4]';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Layer thickness4';  units:='m';  symbol:='z[4]';
 end;
with par[npar + 2] do
 begin
    name:='Soil bulk density4';  units:='g m-3';  symbol:='rhos[4]';
 end;
with par[npar + 3] do
 begin
    name:='Porosity4';  units:='fraction';  symbol:='thetas[4]';
 end;
 
CurrentProc := ModelDef.numstate + 66;
With proc[CurrentProc] do
   begin
      name       := 'C:N Microbial Consump';
      units       := 'g C g-1 N';
      symbol       := 'theta';
      parameters       := 3;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Maximum Microbe C Eff';  units:='unitless';  symbol:='epsilonC';
 end;
with par[npar + 2] do
 begin
    name:='Maximum Microbe N Eff';  units:='unitless';  symbol:='epsilonN';
 end;
with par[npar + 3] do
 begin
    name:='C:N Microbial Byproducts';  units:='g C g-1 N';  symbol:='phi';
 end;
 
CurrentProc := ModelDef.numstate + 67;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Immobilization1';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4m[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 68;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Immobilization2';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4m[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 69;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Immobilization3';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4m[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 70;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Immobilization4';
      units       := 'g N m-2 day-1';
      symbol       := 'Unh4m[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 71;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Immobilization1';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3m[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 72;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Immobilization2';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3m[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 73;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Immobilization3';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3m[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 74;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Immobilization4';
      units       := 'g N m-2 day-1';
      symbol       := 'Uno3m[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 75;
With proc[CurrentProc] do
   begin
      name       := '*N Ntot Immobilization1';
      units       := 'g N m-2 day-1';
      symbol       := 'UNm[1]';
      parameters       := 5;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decomp rate1';  units:='day-1';  symbol:='psi[1]';
 end;
with par[npar + 2] do
 begin
    name:='Microbe NH4 uptake1';  units:='g C g-1 N';  symbol:='alphaNH4[1]';
 end;
with par[npar + 3] do
 begin
    name:='Microbe NO3 uptake1';  units:='g C g-1 N';  symbol:='alphaNO3[1]';
 end;
with par[npar + 4] do
 begin
    name:='Microbial NH4 half sat1';  units:='umol N L-1 H2O';  symbol:='knh4m[1]';
 end;
with par[npar + 5] do
 begin
    name:='Microbial NO3 half sat1';  units:='umol N L-1 H2O';  symbol:='kno3m[1]';
 end;
 
CurrentProc := ModelDef.numstate + 76;
With proc[CurrentProc] do
   begin
      name       := '*N Ntot Immobilization2';
      units       := 'g N m-2 day-1';
      symbol       := 'UNm[2]';
      parameters       := 5;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decomp rate2';  units:='day-1';  symbol:='psi[2]';
 end;
with par[npar + 2] do
 begin
    name:='Microbe NH4 uptake2';  units:='g C g-1 N';  symbol:='alphaNH4[2]';
 end;
with par[npar + 3] do
 begin
    name:='Microbe NO3 uptake2';  units:='g C g-1 N';  symbol:='alphaNO3[2]';
 end;
with par[npar + 4] do
 begin
    name:='Microbial NH4 half sat2';  units:='umol N L-1 H2O';  symbol:='knh4m[2]';
 end;
with par[npar + 5] do
 begin
    name:='Microbial NO3 half sat2';  units:='umol N L-1 H2O';  symbol:='kno3m[2]';
 end;
 
CurrentProc := ModelDef.numstate + 77;
With proc[CurrentProc] do
   begin
      name       := '*N Ntot Immobilization3';
      units       := 'g N m-2 day-1';
      symbol       := 'UNm[3]';
      parameters       := 5;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decomp rate3';  units:='day-1';  symbol:='psi[3]';
 end;
with par[npar + 2] do
 begin
    name:='Microbe NH4 uptake3';  units:='g C g-1 N';  symbol:='alphaNH4[3]';
 end;
with par[npar + 3] do
 begin
    name:='Microbe NO3 uptake3';  units:='g C g-1 N';  symbol:='alphaNO3[3]';
 end;
with par[npar + 4] do
 begin
    name:='Microbial NH4 half sat3';  units:='umol N L-1 H2O';  symbol:='knh4m[3]';
 end;
with par[npar + 5] do
 begin
    name:='Microbial NO3 half sat3';  units:='umol N L-1 H2O';  symbol:='kno3m[3]';
 end;
 
CurrentProc := ModelDef.numstate + 78;
With proc[CurrentProc] do
   begin
      name       := '*N Ntot Immobilization4';
      units       := 'g N m-2 day-1';
      symbol       := 'UNm[4]';
      parameters       := 5;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Decomp rate4';  units:='day-1';  symbol:='psi[4]';
 end;
with par[npar + 2] do
 begin
    name:='Microbe NH4 uptake4';  units:='g C g-1 N';  symbol:='alphaNH4[4]';
 end;
with par[npar + 3] do
 begin
    name:='Microbe NO3 uptake4';  units:='g C g-1 N';  symbol:='alphaNO3[4]';
 end;
with par[npar + 4] do
 begin
    name:='Microbial NH4 half sat4';  units:='umol N L-1 H2O';  symbol:='knh4m[4]';
 end;
with par[npar + 5] do
 begin
    name:='Microbial NO3 half sat4';  units:='umol N L-1 H2O';  symbol:='kno3m[4]';
 end;
 
CurrentProc := ModelDef.numstate + 79;
With proc[CurrentProc] do
   begin
      name       := '*N Microbe Consumption1';
      units       := 'g N m-2 day-1';
      symbol       := 'Mn[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 80;
With proc[CurrentProc] do
   begin
      name       := '*N Microbe Consumption2';
      units       := 'g N m-2 day-1';
      symbol       := 'Mn[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 81;
With proc[CurrentProc] do
   begin
      name       := '*N Microbe Consumption3';
      units       := 'g N m-2 day-1';
      symbol       := 'Mn[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 82;
With proc[CurrentProc] do
   begin
      name       := '*N Microbe Consumption4';
      units       := 'g N m-2 day-1';
      symbol       := 'Mn[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 83;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Efficiency1';
      units       := 'unitless';
      symbol       := 'LambdaC[1]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 84;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Efficiency2';
      units       := 'unitless';
      symbol       := 'LambdaC[2]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 85;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Efficiency3';
      units       := 'unitless';
      symbol       := 'LambdaC[3]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 86;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Efficiency4';
      units       := 'unitless';
      symbol       := 'LambdaC[4]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 87;
With proc[CurrentProc] do
   begin
      name       := '*N Microbial Efficiency1';
      units       := 'unitless';
      symbol       := 'LambdaN[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 88;
With proc[CurrentProc] do
   begin
      name       := '*N Microbial Efficiency2';
      units       := 'unitless';
      symbol       := 'LambdaN[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 89;
With proc[CurrentProc] do
   begin
      name       := '*N Microbial Efficiency3';
      units       := 'unitless';
      symbol       := 'LambdaN[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 90;
With proc[CurrentProc] do
   begin
      name       := '*N Microbial Efficiency4';
      units       := 'unitless';
      symbol       := 'LambdaN[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 91;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Respiratio1';
      units       := 'g C m-2 day-1';
      symbol       := 'Rcm[1]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 92;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Respiratio2';
      units       := 'g C m-2 day-1';
      symbol       := 'Rcm[2]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 93;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Respiratio3';
      units       := 'g C m-2 day-1';
      symbol       := 'Rcm[3]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 94;
With proc[CurrentProc] do
   begin
      name       := '*C Microbial Respiratio4';
      units       := 'g C m-2 day-1';
      symbol       := 'Rcm[4]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 95;
With proc[CurrentProc] do
   begin
      name       := '*N Gross Mineralization1';
      units       := 'g N m-2 day-1';
      symbol       := 'Rnm[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 96;
With proc[CurrentProc] do
   begin
      name       := '*N Gross Mineralization2';
      units       := 'g N m-2 day-1';
      symbol       := 'Rnm[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 97;
With proc[CurrentProc] do
   begin
      name       := '*N Gross Mineralization3';
      units       := 'g N m-2 day-1';
      symbol       := 'Rnm[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 98;
With proc[CurrentProc] do
   begin
      name       := '*N Gross Mineralization4';
      units       := 'g N m-2 day-1';
      symbol       := 'Rnm[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 99;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 dissolved1';
      units       := 'umol N L-1';
      symbol       := 'Enh4aq[1]';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max sorbed NH41';  units:='g N m-2';  symbol:='Vnh4smax[1]';
 end;
with par[npar + 2] do
 begin
    name:='Sorbed NH4 Half Saturat1';  units:='umol N L-1';  symbol:='etaenh4[1]';
 end;
 
CurrentProc := ModelDef.numstate + 100;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 dissolved2';
      units       := 'umol N L-1';
      symbol       := 'Enh4aq[2]';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max sorbed NH42';  units:='g N m-2';  symbol:='Vnh4smax[2]';
 end;
with par[npar + 2] do
 begin
    name:='Sorbed NH4 Half Saturat2';  units:='umol N L-1';  symbol:='etaenh4[2]';
 end;
 
CurrentProc := ModelDef.numstate + 101;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 dissolved3';
      units       := 'umol N L-1';
      symbol       := 'Enh4aq[3]';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max sorbed NH43';  units:='g N m-2';  symbol:='Vnh4smax[3]';
 end;
with par[npar + 2] do
 begin
    name:='Sorbed NH4 Half Saturat3';  units:='umol N L-1';  symbol:='etaenh4[3]';
 end;
 
CurrentProc := ModelDef.numstate + 102;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 dissolved4';
      units       := 'umol N L-1';
      symbol       := 'Enh4aq[4]';
      parameters       := 2;
      ptype       := ptGroup3;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Max sorbed NH44';  units:='g N m-2';  symbol:='Vnh4smax[4]';
 end;
with par[npar + 2] do
 begin
    name:='Sorbed NH4 Half Saturat4';  units:='umol N L-1';  symbol:='etaenh4[4]';
 end;
 
CurrentProc := ModelDef.numstate + 103;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 dissolved1';
      units       := 'umol N L-1';
      symbol       := 'Eno3aq[1]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 104;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 dissolved2';
      units       := 'umol N L-1';
      symbol       := 'Eno3aq[2]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 105;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 dissolved3';
      units       := 'umol N L-1';
      symbol       := 'Eno3aq[3]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 106;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 dissolved4';
      units       := 'umol N L-1';
      symbol       := 'Eno3aq[4]';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 107;
With proc[CurrentProc] do
   begin
      name       := '*N Net N Mineralization1';
      units       := 'g N m-2 day-1';
      symbol       := 'Nnmin[1]';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 108;
With proc[CurrentProc] do
   begin
      name       := '*N Net N Mineralization2';
      units       := 'g N m-2 day-1';
      symbol       := 'Nnmin[2]';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 109;
With proc[CurrentProc] do
   begin
      name       := '*N Net N Mineralization3';
      units       := 'g N m-2 day-1';
      symbol       := 'Nnmin[3]';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 110;
With proc[CurrentProc] do
   begin
      name       := '*N Net N Mineralization4';
      units       := 'g N m-2 day-1';
      symbol       := 'Nnmin[4]';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 111;
With proc[CurrentProc] do
   begin
      name       := '*C: DOC aqueous1';
      units       := 'umol C L-1 H2O';
      symbol       := 'Docaq[1]';
      parameters       := 4;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Dissolved DOC fraction1';  units:='none';  symbol:='alphaDOC[1]';
 end;
with par[npar + 2] do
 begin
    name:='Max Sorbed DOC1';  units:='g C g-1 soil';  symbol:='Vdocsmax[1]';
 end;
with par[npar + 3] do
 begin
    name:='DOC sorbtion half sat c1';  units:='umol C L-1 H2O';  symbol:='etaDoc[1]';
 end;
with par[npar + 4] do
 begin
    name:='C:N dissolved organic m1';  units:='g C g-1 N';  symbol:='qDOM[1]';
 end;
 
CurrentProc := ModelDef.numstate + 112;
With proc[CurrentProc] do
   begin
      name       := '*C: DOC aqueous2';
      units       := 'umol C L-1 H2O';
      symbol       := 'Docaq[2]';
      parameters       := 4;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Dissolved DOC fraction2';  units:='none';  symbol:='alphaDOC[2]';
 end;
with par[npar + 2] do
 begin
    name:='Max Sorbed DOC2';  units:='g C g-1 soil';  symbol:='Vdocsmax[2]';
 end;
with par[npar + 3] do
 begin
    name:='DOC sorbtion half sat c2';  units:='umol C L-1 H2O';  symbol:='etaDoc[2]';
 end;
with par[npar + 4] do
 begin
    name:='C:N dissolved organic m2';  units:='g C g-1 N';  symbol:='qDOM[2]';
 end;
 
CurrentProc := ModelDef.numstate + 113;
With proc[CurrentProc] do
   begin
      name       := '*C: DOC aqueous3';
      units       := 'umol C L-1 H2O';
      symbol       := 'Docaq[3]';
      parameters       := 4;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Dissolved DOC fraction3';  units:='none';  symbol:='alphaDOC[3]';
 end;
with par[npar + 2] do
 begin
    name:='Max Sorbed DOC3';  units:='g C g-1 soil';  symbol:='Vdocsmax[3]';
 end;
with par[npar + 3] do
 begin
    name:='DOC sorbtion half sat c3';  units:='umol C L-1 H2O';  symbol:='etaDoc[3]';
 end;
with par[npar + 4] do
 begin
    name:='C:N dissolved organic m3';  units:='g C g-1 N';  symbol:='qDOM[3]';
 end;
 
CurrentProc := ModelDef.numstate + 114;
With proc[CurrentProc] do
   begin
      name       := '*C: DOC aqueous4';
      units       := 'umol C L-1 H2O';
      symbol       := 'Docaq[4]';
      parameters       := 4;
      ptype       := ptGroup2;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Dissolved DOC fraction4';  units:='none';  symbol:='alphaDOC[4]';
 end;
with par[npar + 2] do
 begin
    name:='Max Sorbed DOC4';  units:='g C g-1 soil';  symbol:='Vdocsmax[4]';
 end;
with par[npar + 3] do
 begin
    name:='DOC sorbtion half sat c4';  units:='umol C L-1 H2O';  symbol:='etaDoc[4]';
 end;
with par[npar + 4] do
 begin
    name:='C:N dissolved organic m4';  units:='g C g-1 N';  symbol:='qDOM[4]';
 end;
 
CurrentProc := ModelDef.numstate + 115;
With proc[CurrentProc] do
   begin
      name       := '*N: DON aqueous1';
      units       := 'umol N L-1 H2O';
      symbol       := 'Donaq[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 116;
With proc[CurrentProc] do
   begin
      name       := '*N: DON aqueous2';
      units       := 'umol N L-1 H2O';
      symbol       := 'Donaq[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 117;
With proc[CurrentProc] do
   begin
      name       := '*N: DON aqueous3';
      units       := 'umol N L-1 H2O';
      symbol       := 'Donaq[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 118;
With proc[CurrentProc] do
   begin
      name       := '*N: DON aqueous4';
      units       := 'umol N L-1 H2O';
      symbol       := 'Donaq[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 119;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss downslope1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4d[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 120;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss downslope2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4d[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 121;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss downslope3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4d[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 122;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss downslope4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4d[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 123;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss downslope1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3d[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 124;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss downslope2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3d[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 125;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss downslope3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3d[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 126;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss downslope4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3d[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 127;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss channel1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4c[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 128;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss channel2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4c[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 129;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss channel3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4c[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 130;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss channel4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4c[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 131;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss channel1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3c[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 132;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss channel2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3c[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 133;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss channel3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3c[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 134;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss channel4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3c[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 135;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss drainage1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4l[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 136;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss drainage2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4l[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 137;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss drainage3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4l[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 138;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss drainage4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4l[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 139;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss drainage1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3l[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 140;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss drainage2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3l[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 141;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss drainage3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3l[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 142;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss drainage4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3l[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 143;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss all directi1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 144;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss all directi2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 145;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss all directi3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 146;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 loss all directi4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnh4[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 147;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss all directi1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 148;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss all directi2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 149;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss all directi3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 150;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 loss all directi4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lno3[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 151;
With proc[CurrentProc] do
   begin
      name       := '*N DIN tot leaching los1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lndin[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 152;
With proc[CurrentProc] do
   begin
      name       := '*N DIN tot leaching los2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lndin[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 153;
With proc[CurrentProc] do
   begin
      name       := '*N DIN tot leaching los3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lndin[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 154;
With proc[CurrentProc] do
   begin
      name       := '*N DIN tot leaching los4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lndin[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 155;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss downslope1';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocd[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 156;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss downslope2';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocd[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 157;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss downslope3';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocd[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 158;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss downslope4';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocd[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 159;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss downslope1';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldond[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 160;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss downslope2';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldond[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 161;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss downslope3';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldond[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 162;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss downslope4';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldond[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 163;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss channel1';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocc[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 164;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss channel2';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocc[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 165;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss channel3';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocc[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 166;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss channel4';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocc[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 167;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss channel1';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonc[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 168;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss channel2';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonc[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 169;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss channel3';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonc[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 170;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss channel4';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonc[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 171;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss drainage1';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocl[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 172;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss drainage2';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocl[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 173;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss drainage3';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocl[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 174;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss drainage4';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldocl[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 175;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss drainage1';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonl[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 176;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss drainage2';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonl[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 177;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss drainage3';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonl[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 178;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss drainage4';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldonl[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 179;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss total1';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldoc[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 180;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss total2';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldoc[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 181;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss total3';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldoc[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 182;
With proc[CurrentProc] do
   begin
      name       := '*C DOC loss total4';
      units       := 'g C m-2 day-1';
      symbol       := 'Ldoc[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 183;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss total1';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldon[1]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 184;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss total2';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldon[2]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 185;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss total3';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldon[3]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 186;
With proc[CurrentProc] do
   begin
      name       := '*N DON loss total4';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldon[4]';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 187;
With proc[CurrentProc] do
   begin
      name       := 'N total leaching downsl';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnd';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 188;
With proc[CurrentProc] do
   begin
      name       := 'N total leaching channe';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnc';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 189;
With proc[CurrentProc] do
   begin
      name       := 'N total loss (aq+denit)';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnt';
      parameters       := 0;
      ptype       := ptGroup2;
   end;
 
CurrentProc := ModelDef.numstate + 190;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Moisture1';
      units       := 'unitless';
      symbol       := 'Msnitr[1]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 191;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Moisture2';
      units       := 'unitless';
      symbol       := 'Msnitr[2]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 192;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Moisture3';
      units       := 'unitless';
      symbol       := 'Msnitr[3]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 193;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Moisture4';
      units       := 'unitless';
      symbol       := 'Msnitr[4]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 194;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Temp Res1';
      units       := 'unitless';
      symbol       := 'Tnitr[1]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 195;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Temp Res2';
      units       := 'unitless';
      symbol       := 'Tnitr[2]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 196;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Temp Res3';
      units       := 'unitless';
      symbol       := 'Tnitr[3]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 197;
With proc[CurrentProc] do
   begin
      name       := '*Nitrification Temp Res4';
      units       := 'unitless';
      symbol       := 'Tnitr[4]';
      parameters       := 0;
      ptype       := ptGroup5;
   end;
 
CurrentProc := ModelDef.numstate + 198;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Nitrification1';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnitr[1]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 199;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Nitrification2';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnitr[2]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 200;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Nitrification3';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnitr[3]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 201;
With proc[CurrentProc] do
   begin
      name       := '*N NH4 Nitrification4';
      units       := 'g N m-2 day-1';
      symbol       := 'Lnitr[4]';
      parameters       := 0;
      ptype       := ptGroup1;
   end;
 
CurrentProc := ModelDef.numstate + 202;
With proc[CurrentProc] do
   begin
      name       := 'Nitrification params';
      units       := 'g N m-2 day-1';
      symbol       := 'dum4';
      parameters       := 10;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Nitrification rate';  units:='day-1';  symbol:='gammaNitr';
 end;
with par[npar + 2] do
 begin
    name:='Nitrification half sat';  units:='umol N L-1 H2O';  symbol:='knh4Nitr';
 end;
with par[npar + 3] do
 begin
    name:='Nitr Max wfps';  units:='fraction';  symbol:='lambdaMax';
 end;
with par[npar + 4] do
 begin
    name:='Nitr Opt wfps';  units:='fraction';  symbol:='lambdaOpt';
 end;
with par[npar + 5] do
 begin
    name:='Nitr Min wfps';  units:='fraction';  symbol:='lambdaMin';
 end;
with par[npar + 6] do
 begin
    name:='Nitr Mois resp param';  units:='unitless';  symbol:='dnitr';
 end;
with par[npar + 7] do
 begin
    name:='Nitr Max Temp';  units:='deg C';  symbol:='Tnitmax';
 end;
with par[npar + 8] do
 begin
    name:='Nitr Opt Temp';  units:='deg C';  symbol:='Tnitopt';
 end;
with par[npar + 9] do
 begin
    name:='Nitr Temp resp param';  units:='unitless';  symbol:='anitr';
 end;
with par[npar + 10] do
 begin
    name:='Nitr Temp resp param';  units:='unitless';  symbol:='bnitr';
 end;
 
CurrentProc := ModelDef.numstate + 203;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Denitrification 1';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldenit[1]';
      parameters       := 1;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Denitrification switch1';  units:='unitless';  symbol:='gammaDenit[1]';
 end;
 
CurrentProc := ModelDef.numstate + 204;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Denitrification 2';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldenit[2]';
      parameters       := 1;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Denitrification switch2';  units:='unitless';  symbol:='gammaDenit[2]';
 end;
 
CurrentProc := ModelDef.numstate + 205;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Denitrification 3';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldenit[3]';
      parameters       := 1;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Denitrification switch3';  units:='unitless';  symbol:='gammaDenit[3]';
 end;
 
CurrentProc := ModelDef.numstate + 206;
With proc[CurrentProc] do
   begin
      name       := '*N NO3 Denitrification 4';
      units       := 'g N m-2 day-1';
      symbol       := 'Ldenit[4]';
      parameters       := 1;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Denitrification switch4';  units:='unitless';  symbol:='gammaDenit[4]';
 end;
 
CurrentProc := ModelDef.numstate + 207;
With proc[CurrentProc] do
   begin
      name       := 'N NO3 Denitrification P';
      units       := 'g N m-2 day-1';
      symbol       := 'dum5';
      parameters       := 9;
      ptype       := ptGroup1;
   end;
npar:=ParCount(CurrentProc);
with par[npar + 1] do
 begin
    name:='Nitrate coefficient';  units:='unitless';  symbol:='aFno3';
 end;
with par[npar + 2] do
 begin
    name:='Nitrate exponent';  units:='unitless';  symbol:='bFno3';
 end;
with par[npar + 3] do
 begin
    name:='Respiration coefficient';  units:='unitless';  symbol:='aFco2';
 end;
with par[npar + 4] do
 begin
    name:='Respiration exponent';  units:='unitless';  symbol:='bFco2';
 end;
with par[npar + 5] do
 begin
    name:='Soil water minimum';  units:='unitless';  symbol:='aFh2o';
 end;
with par[npar + 6] do
 begin
    name:='Soil water parameter';  units:='unitless';  symbol:='bFh2o';
 end;
with par[npar + 7] do
 begin
    name:='Soil water factor';  units:='wfps-1';  symbol:='cFh2o';
 end;
with par[npar + 8] do
 begin
    name:='Soil water parameter';  units:='unitless';  symbol:='dFh2o';
 end;
with par[npar + 9] do
 begin
    name:='Soil water parameter';  units:='unitless';  symbol:='eFh2o';
 end;
 
CurrentProc := ModelDef.numstate + 208;
With proc[CurrentProc] do
   begin
      name       := 'C:N Veg Actual';
      units       := 'g C g-1 N';
      symbol       := 'qveg';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 209;
With proc[CurrentProc] do
   begin
      name       := 'C:N Soil Actual';
      units       := 'g C g-1 N';
      symbol       := 'qsoil';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 210;
With proc[CurrentProc] do
   begin
      name       := 'NPP daily';
      units       := 'g C m-2 day-1';
      symbol       := 'NPP';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 211;
With proc[CurrentProc] do
   begin
      name       := 'NEP daily';
      units       := 'g C m-2 day-1';
      symbol       := 'NEP';
      parameters       := 0;
      ptype       := ptGroup3;
   end;
 
CurrentProc := ModelDef.numstate + 212;
With proc[CurrentProc] do
   begin
      name       := 'C Ecosystem total';
      units       := 'g C m-2';
      symbol       := 'Ect';
      parameters       := 0;
      ptype       := ptGroup4;
   end;
 
CurrentProc := ModelDef.numstate + 213;
With proc[CurrentProc] do
   begin
      name       := 'N Ecosystem total';
      units       := 'g N m-2';
      symbol       := 'Ent';
      parameters       := 0;
      ptype       := ptGroup4;
   end;

{ Set the total number of drivers in the model. The maximum number of drivers is
  maxdrive, in unit stypes. }
ModelDef.numdrive := 40;

{ Set the names, units, and symbols of the drivers. The maximum length for the
  name, units and symbol is 20 characters. }
 
with drive[1] do
 begin
    name:='D: C Atmospheric CO2';  units:='ml m-3';  symbol:='Ec';
 end;
 
with drive[2] do
 begin
    name:='D: Air temperature max';  units:='deg C';  symbol:='Tamax';
 end;
 
with drive[3] do
 begin
    name:='D: Air temperature min';  units:='deg C';  symbol:='Tamin';
 end;
 
with drive[4] do
 begin
    name:='D: I Above canopy irrad';  units:='MJ m-2 day-1';  symbol:='Io';
 end;
 
with drive[5] do
 begin
    name:='D: NH4 Atmospheric Inpu';  units:='g N m-2 day-1';  symbol:='Rnh4e';
 end;
 
with drive[6] do
 begin
    name:='D: NO3 Atmospheric Inpu';  units:='g N m-2 day-1';  symbol:='Rno3e';
 end;
 
with drive[7] do
 begin
    name:='D: DOC Atmospheric Inpu';  units:='g N m-2 day-1';  symbol:='Rdoce';
 end;
 
with drive[8] do
 begin
    name:='D: DON Atmospheric Inpu';  units:='g N m-2 day-1';  symbol:='Rdone';
 end;
 
with drive[9] do
 begin
    name:='*D: NH4 upslope input1';  units:='g N m-2 day-1';  symbol:='Rnh4u[1]';
 end;
 
with drive[10] do
 begin
    name:='*D: NH4 upslope input2';  units:='g N m-2 day-1';  symbol:='Rnh4u[2]';
 end;
 
with drive[11] do
 begin
    name:='*D: NH4 upslope input3';  units:='g N m-2 day-1';  symbol:='Rnh4u[3]';
 end;
 
with drive[12] do
 begin
    name:='*D: NH4 upslope input4';  units:='g N m-2 day-1';  symbol:='Rnh4u[4]';
 end;
 
with drive[13] do
 begin
    name:='*D: NO3 upslope input1';  units:='g N m-2 day-1';  symbol:='Rno3u[1]';
 end;
 
with drive[14] do
 begin
    name:='*D: NO3 upslope input2';  units:='g N m-2 day-1';  symbol:='Rno3u[2]';
 end;
 
with drive[15] do
 begin
    name:='*D: NO3 upslope input3';  units:='g N m-2 day-1';  symbol:='Rno3u[3]';
 end;
 
with drive[16] do
 begin
    name:='*D: NO3 upslope input4';  units:='g N m-2 day-1';  symbol:='Rno3u[4]';
 end;
 
with drive[17] do
 begin
    name:='*D: DOC upslope input1';  units:='g C m-2 day-1';  symbol:='Rdocu[1]';
 end;
 
with drive[18] do
 begin
    name:='*D: DOC upslope input2';  units:='g C m-2 day-1';  symbol:='Rdocu[2]';
 end;
 
with drive[19] do
 begin
    name:='*D: DOC upslope input3';  units:='g C m-2 day-1';  symbol:='Rdocu[3]';
 end;
 
with drive[20] do
 begin
    name:='*D: DOC upslope input4';  units:='g C m-2 day-1';  symbol:='Rdocu[4]';
 end;
 
with drive[21] do
 begin
    name:='*D: DON upslope input1';  units:='g N m-2 day-1';  symbol:='Rdonu[1]';
 end;
 
with drive[22] do
 begin
    name:='*D: DON upslope input2';  units:='g N m-2 day-1';  symbol:='Rdonu[2]';
 end;
 
with drive[23] do
 begin
    name:='*D: DON upslope input3';  units:='g N m-2 day-1';  symbol:='Rdonu[3]';
 end;
 
with drive[24] do
 begin
    name:='*D: DON upslope input4';  units:='g N m-2 day-1';  symbol:='Rdonu[4]';
 end;
 
with drive[25] do
 begin
    name:='*D: H2O content1';  units:='mm H2O';  symbol:='Wr[1]';
 end;
 
with drive[26] do
 begin
    name:='*D: H2O content2';  units:='mm H2O';  symbol:='Wr[2]';
 end;
 
with drive[27] do
 begin
    name:='*D: H2O content3';  units:='mm H2O';  symbol:='Wr[3]';
 end;
 
with drive[28] do
 begin
    name:='*D: H2O content4';  units:='mm H2O';  symbol:='Wr[4]';
 end;
 
with drive[29] do
 begin
    name:='*D: FlxH2O downslope1';  units:='mm H2O day-1';  symbol:='Drd[1]';
 end;
 
with drive[30] do
 begin
    name:='*D: FlxH2O downslope2';  units:='mm H2O day-1';  symbol:='Drd[2]';
 end;
 
with drive[31] do
 begin
    name:='*D: FlxH2O downslope3';  units:='mm H2O day-1';  symbol:='Drd[3]';
 end;
 
with drive[32] do
 begin
    name:='*D: FlxH2O downslope4';  units:='mm H2O day-1';  symbol:='Drd[4]';
 end;
 
with drive[33] do
 begin
    name:='*D: FlxH2O to channel1';  units:='mm H2O day-1';  symbol:='Drc[1]';
 end;
 
with drive[34] do
 begin
    name:='*D: FlxH2O to channel2';  units:='mm H2O day-1';  symbol:='Drc[2]';
 end;
 
with drive[35] do
 begin
    name:='*D: FlxH2O to channel3';  units:='mm H2O day-1';  symbol:='Drc[3]';
 end;
 
with drive[36] do
 begin
    name:='*D: FlxH2O to channel4';  units:='mm H2O day-1';  symbol:='Drc[4]';
 end;
 
with drive[37] do
 begin
    name:='*D: FlxH2O to lower lay1';  units:='mm H2O day-1';  symbol:='Drl[1]';
 end;
 
with drive[38] do
 begin
    name:='*D: FlxH2O to lower lay2';  units:='mm H2O day-1';  symbol:='Drl[2]';
 end;
 
with drive[39] do
 begin
    name:='*D: FlxH2O to lower lay3';  units:='mm H2O day-1';  symbol:='Drl[3]';
 end;
 
with drive[40] do
 begin
    name:='*D: FlxH2O to lower lay4';  units:='mm H2O day-1';  symbol:='Drl[4]';
 end;

{ The first numstate processes are the derivatives of the state variables. The
  code sets the names, units and symbols accordingly.}
for i:= 1 to ModelDef.numstate do proc[i].name:='d'+stat[i].name+'dt';
for i:= 1 to ModelDef.numstate do proc[i].units := stat[i].units + 't-1';
for i:= 1 to ModelDef.numstate do proc[i].symbol := 'd' + stat[i].symbol + 'dt';

{ Code to sum up the total number of parameters in the model. Do not change the
  next few lines. }
ModelDef.numparam := 0;
for i := 1 to ModelDef.NumProcess do
  ModelDef.numparam := ModelDef.numparam + proc[i].parameters;

end; // counts procedure


{ A procedure to calculate the value of all states and processes at the current
  time. This function accesses time, state variables and process variables by
  reference, ie it uses the same array as the calling routine. It does not use
  the global variables time, stat and proc because values calculated during
  integration might later be discarded. It does access the global variables par,
  drive and ModelDef directly because those values are not modified.

  The model equations are written using variable names which correspond to the
  actual name instead of using the global arrays (i.e. SoilWater instead of
  stat[7].value). This makes it necessary to switch all values into local
  variables, do all the calculations and then put everything back into the
  global variables. Lengthy but worth it in terms of readability of the code. }

// Choose either GlobalPs, ArcticPs, or none here so the appropriate Ps model is compiled below.
{$DEFINE none}

PROCEDURE processes(time:double; dtime:double; var tdrive:drivearray;
                       var tpar:paramarray; var tstat:statearray;
                       var tproc:processarray; CalculateDiscrete:Boolean);
{$IFDEF GlobalPs}
const
// Global Ps parameters
 x1 = 11.04;             x2 = 0.03;
 x5 = 0.216;             x6 = 0.6;
 x7 = 3.332;             x8 = 0.004;
 x9 = 1.549;             x10 = 1.156;
 gammastar = 0;          kCO2 = 995.4;  }
{$ENDIF}

// Modify constant above (line above "procedure processes..." line )to specify
// which Ps model and it's constants should be compiled. Choosing a Ps model
// automatically includes the Et and Misc constants (i.e. Gem is assumed).

{$IFDEF ArcticPs}
const
// Arctic Ps parameters
x1 = 0.192;	x2 = 0.125;
x5 = 2.196;	x6 = 50.41;
x7 = 0.161;	x8 = 14.78;
x9 = 1.146;
gammastar = 0.468;	kCO2 = 500.3;
{$ENDIF}

{$IFDEF ArcticPs OR GlobalPs}
//const
// General Et parameters
aE1 = 0.0004;    aE2 = 150;  aE3 = 1.21;   aE4 = 6.11262E5;

// Other constants
cp = 1.012E-9; //specific heat air MJ kg-1 oC-1
sigmaSB = 4.9e-9; //stefan-Boltzmann MJ m-2 day-1 K-4
S0 = 117.5; //solar constant MJ m-2 day-1
bHI1 =0.23;
bHI2 =0.48;
mw = 2.99; //kg h2o MJ-1
alphaMS = 2; //mm oC-1 day-1                                 }
{$ENDIF}

var
{ List the variable names you are going to use here. Generally, this list
  includes all the symbols you defined in the procedure counts above. The order
  in which you list them does not matter. }
{States}
Enh4, dEnh4dt: array[1..4] of double;
Eno3, dEno3dt: array[1..4] of double;
Bc, dBcdt, 
Bn, dBndt :double;
Dc, dDcdt: array[1..4] of double;
Dn, dDndt: array[1..4] of double;
Vc, dVcdt, 
Vn, dVndt, 
mrNup, dmrNupdt, 
Jday, dJdaydt, 
Dday, dDdaydt, 
CumUcv, dCumUcvdt, 
CumRcv, dCumRcvdt, 
CumRcva, dCumRcvadt, 
CumRcvw, dCumRcvwdt, 
CumLcv, dCumLcvdt, 
CumRNe, dCumRNedt, 
CumRnh4e, dCumRnh4edt, 
CumRno3e, dCumRno3edt, 
CumRN, dCumRNdt, 
CumLnv, dCumLnvdt, 
CumUnh4v, dCumUnh4vdt, 
CumUno3v, dCumUno3vdt, 
CumUnv, dCumUnvdt, 
CumLnh4d, dCumLnh4ddt, 
CumLno3d, dCumLno3ddt, 
CumLnh4c, dCumLnh4cdt, 
CumLno3c, dCumLno3cdt, 
CumRnm, dCumRnmdt, 
CumUnh4m, dCumUnh4mdt, 
CumUno3m, dCumUno3mdt, 
CumUnm, dCumUnmdt, 
CumNNmin, dCumNNmindt, 
CumRcm, dCumRcmdt, 
CumNfix, dCumNfixdt, 
CumLcve, dCumLcvedt, 
CumLcvd, dCumLcvddt, 
CumLcvf, dCumLcvfdt, 
CumLcvr, dCumLcvrdt, 
CumLcva, dCumLcvadt, 
CumLcvw, dCumLcvwdt, 
CumLnve, dCumLnvedt, 
CumLnvd, dCumLnvddt, 
CumLnvf, dCumLnvfdt, 
CumLnvr, dCumLnvrdt, 
CumLnva, dCumLnvadt, 
CumLnvw, dCumLnvwdt, 
CumLdocd, dCumLdocddt, 
CumLdond, dCumLdonddt, 
CumLdocc, dCumLdoccdt, 
CumLdonc, dCumLdoncdt, 
CumLdoc, dCumLdocdt, 
CumLdon, dCumLdondt, 
CumLnd, dCumLnddt, 
CumLnc, dCumLncdt, 
CumLnt, dCumLntdt, 
CumLnitr, dCumLnitrdt, 
CumLdenit, dCumLdenitdt, 
CumNPP, dCumNPPdt, 
CumNEP, dCumNEPdt, 
CumLnh4, dCumLnh4dt, 
CumLno3, dCumLno3dt, 

{processes and associated parameters}
Ta, 
fc, fcmin, 
dum3, Jdegstart, Ddbud, Ddfull, tau, 
Ba, Bamax, c, 
q, qmin, qmax, qa, qw, 
Sc, bbc, 
Sn, bbn, 
GC, ggc, kc, 
Gnh4, ggnh4, knh4, 
Gno3, ggno3, kno3, 
UCv, ki :double;
Unh4v: array[1..4] of double;
Uno3v: array[1..4] of double;
UNv, ks, 
rNup, 
Unfix, gnfix, rnfix, knfix, 
Swle, betaSle, Jdestart, Jdeend, 
Swlr, betaSlr, Jdrstart, Jdrend, 
Swld, betaSld, Jddstart, Jddend, 
Swlw, betaSlw, Jdwstart, Jdwend, 
dum6, ma, mw :double;
LCv: array[1..4] of double;
LNv: array[1..4] of double;
RCv, ra, rw, 
RCva, 
RCvw, 
A, aa, h, 
dum, Q10gc, Q10gn, Q10ra, Q10rw, Q10d, Q10Nfix, 
Msp, Ww, bmsp :double;
Msd: array[1..4] of double;
dum7, alphaSD, Wrmin, Wropt, 
Lcve, 
Lcvd, 
Lcvf, 
Lcvr, 
Lcva, 
Lcvw, 
Lnve, 
Lnvd, 
Lnvf, 
Lnvr, 
Lnva, 
Lnvw, 
swNfix, 
Hcv, Jdharvest, gammaH, 
Hnv :double;
dum2, z, rhos, thetas: array[1..4] of double;
theta, epsilonC, epsilonN, phi :double;
Unh4m: array[1..4] of double;
Uno3m: array[1..4] of double;
UNm, psi, alphaNH4, alphaNO3, knh4m, kno3m: array[1..4] of double;
Mn: array[1..4] of double;
LambdaC: array[1..4] of double;
LambdaN: array[1..4] of double;
Rcm: array[1..4] of double;
Rnm: array[1..4] of double;
Enh4aq, Vnh4smax, etaenh4: array[1..4] of double;
Eno3aq: array[1..4] of double;
Nnmin: array[1..4] of double;
Docaq, alphaDOC, Vdocsmax, etaDoc, qDOM: array[1..4] of double;
Donaq: array[1..4] of double;
Lnh4d: array[1..4] of double;
Lno3d: array[1..4] of double;
Lnh4c: array[1..4] of double;
Lno3c: array[1..4] of double;
Lnh4l: array[0..4] of double;
Lno3l: array[0..4] of double;
Lnh4: array[1..4] of double;
Lno3: array[1..4] of double;
Lndin: array[1..4] of double;
Ldocd: array[1..4] of double;
Ldond: array[1..4] of double;
Ldocc: array[1..4] of double;
Ldonc: array[1..4] of double;
Ldocl: array[0..4] of double;
Ldonl: array[0..4] of double;
Ldoc: array[1..4] of double;
Ldon: array[1..4] of double;
Lnd, 
Lnc, 
Lnt :double;
Msnitr: array[1..4] of double;
Tnitr: array[1..4] of double;
Lnitr: array[1..4] of double;
dum4, gammaNitr, knh4Nitr, lambdaMax, lambdaOpt, lambdaMin, dnitr, Tnitmax, Tnitopt, anitr, bnitr :double;
Ldenit, gammaDenit: array[1..4] of double;
dum5, aFno3, bFno3, aFco2, bFco2, aFh2o, bFh2o, cFh2o, dFh2o, eFh2o, 
qveg, 
qsoil, 
NPP, 
NEP, 
Ect, 
Ent, 

{drivers}
Ec, 
Tamax, 
Tamin, 
Io, 
Rnh4e, 
Rno3e, 
Rdoce, 
Rdone :double;
Rnh4u: array[1..4] of double;
Rno3u: array[1..4] of double;
Rdocu: array[1..4] of double;
Rdonu: array[1..4] of double;
Wr: array[1..4] of double;
Drd: array[1..4] of double;
Drc: array[1..4] of double;
Drl: array[1..4] of double;

{other}
Rnh4ee: array[1..4] of double;
Rno3ee: array[1..4] of double;
Rdocee: array[1..4] of double;
Rdonee: array[1..4] of double;


npar, j, jj, kk, ll, tnum:integer;

{ Functions or procedures }

begin
{ Copy the drivers from the global array, drive, into the local variables. }
Ec := tdrive[1].value;
Tamax := tdrive[2].value;
Tamin := tdrive[3].value;
Io := tdrive[4].value;
Rnh4e := tdrive[5].value;
Rno3e := tdrive[6].value;
Rdoce := tdrive[7].value;
Rdone := tdrive[8].value;
for jj := 1 to 4 do Rnh4u[jj] := tdrive[9 + jj - 1].value;
for jj := 1 to 4 do Rno3u[jj] := tdrive[13 + jj - 1].value;
for jj := 1 to 4 do Rdocu[jj] := tdrive[17 + jj - 1].value;
for jj := 1 to 4 do Rdonu[jj] := tdrive[21 + jj - 1].value;
for jj := 1 to 4 do Wr[jj] := tdrive[25 + jj - 1].value;
for jj := 1 to 4 do Drd[jj] := tdrive[29 + jj - 1].value;
for jj := 1 to 4 do Drc[jj] := tdrive[33 + jj - 1].value;
for jj := 1 to 4 do Drl[jj] := tdrive[37 + jj - 1].value;

{ Copy the state variables from the global array into the local variables. }
for jj := 1 to 4 do Enh4[jj] := tstat[0 + jj].value;
for jj := 1 to 4 do Eno3[jj] := tstat[4 + jj].value;
Bc := tstat[9].value;
Bn := tstat[10].value;
for jj := 1 to 4 do Dc[jj] := tstat[10 + jj].value;
for jj := 1 to 4 do Dn[jj] := tstat[14 + jj].value;
Vc := tstat[19].value;
Vn := tstat[20].value;
mrNup := tstat[21].value;
Jday := tstat[22].value;
Dday := tstat[23].value;
CumUcv := tstat[24].value;
CumRcv := tstat[25].value;
CumRcva := tstat[26].value;
CumRcvw := tstat[27].value;
CumLcv := tstat[28].value;
CumRNe := tstat[29].value;
CumRnh4e := tstat[30].value;
CumRno3e := tstat[31].value;
CumRN := tstat[32].value;
CumLnv := tstat[33].value;
CumUnh4v := tstat[34].value;
CumUno3v := tstat[35].value;
CumUnv := tstat[36].value;
CumLnh4d := tstat[37].value;
CumLno3d := tstat[38].value;
CumLnh4c := tstat[39].value;
CumLno3c := tstat[40].value;
CumRnm := tstat[41].value;
CumUnh4m := tstat[42].value;
CumUno3m := tstat[43].value;
CumUnm := tstat[44].value;
CumNNmin := tstat[45].value;
CumRcm := tstat[46].value;
CumNfix := tstat[47].value;
CumLcve := tstat[48].value;
CumLcvd := tstat[49].value;
CumLcvf := tstat[50].value;
CumLcvr := tstat[51].value;
CumLcva := tstat[52].value;
CumLcvw := tstat[53].value;
CumLnve := tstat[54].value;
CumLnvd := tstat[55].value;
CumLnvf := tstat[56].value;
CumLnvr := tstat[57].value;
CumLnva := tstat[58].value;
CumLnvw := tstat[59].value;
CumLdocd := tstat[60].value;
CumLdond := tstat[61].value;
CumLdocc := tstat[62].value;
CumLdonc := tstat[63].value;
CumLdoc := tstat[64].value;
CumLdon := tstat[65].value;
CumLnd := tstat[66].value;
CumLnc := tstat[67].value;
CumLnt := tstat[68].value;
CumLnitr := tstat[69].value;
CumLdenit := tstat[70].value;
CumNPP := tstat[71].value;
CumNEP := tstat[72].value;
CumLnh4 := tstat[73].value;
CumLno3 := tstat[74].value;

{ And now copy the parameters into the local variables. No need to copy the
  processes from the global array into local variables. Process values will be
  calculated by this procedure.

  Copy the parameters for each process separately using the function ParCount
  to keep track of the number of parameters in the preceeding processes.
  npar now contains the number of parameters in the preceding processes.
  copy the value of the first parameter of this process into it's local
  variable }
npar:=ParCount(ModelDef.numstate + 2);
fcmin := par[npar + 1].value;

npar:=ParCount(ModelDef.numstate + 3);
Jdegstart := par[npar + 1].value;
Ddbud := par[npar + 2].value;
Ddfull := par[npar + 3].value;
tau := par[npar + 4].value;
 
npar:=ParCount(ModelDef.numstate + 4);
Bamax := par[npar + 1].value;
c := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 5);
qmin := par[npar + 1].value;
qmax := par[npar + 2].value;
qa := par[npar + 3].value;
qw := par[npar + 4].value;
 
npar:=ParCount(ModelDef.numstate + 6);
bbc := par[npar + 1].value;
 
npar:=ParCount(ModelDef.numstate + 7);
bbn := par[npar + 1].value;
 
npar:=ParCount(ModelDef.numstate + 8);
ggc := par[npar + 1].value;
kc := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 9);
ggnh4 := par[npar + 1].value;
knh4 := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 10);
ggno3 := par[npar + 1].value;
kno3 := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 11);
ki := par[npar + 1].value;
 
npar:=ParCount(ModelDef.numstate + 20);
ks := par[npar + 1].value;
 
npar:=ParCount(ModelDef.numstate + 22);
gnfix := par[npar + 1].value;
rnfix := par[npar + 2].value;
knfix := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 23);
betaSle := par[npar + 1].value;
Jdestart := par[npar + 2].value;
Jdeend := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 24);
betaSlr := par[npar + 1].value;
Jdrstart := par[npar + 2].value;
Jdrend := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 25);
betaSld := par[npar + 1].value;
Jddstart := par[npar + 2].value;
Jddend := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 26);
betaSlw := par[npar + 1].value;
Jdwstart := par[npar + 2].value;
Jdwend := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 27);
ma := par[npar + 1].value;
mw := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 36);
ra := par[npar + 1].value;
rw := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 39);
aa := par[npar + 1].value;
h := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 40);
Q10gc := par[npar + 1].value;
Q10gn := par[npar + 2].value;
Q10ra := par[npar + 3].value;
Q10rw := par[npar + 4].value;
Q10d := par[npar + 5].value;
Q10Nfix := par[npar + 6].value;
 
npar:=ParCount(ModelDef.numstate + 41);
Ww := par[npar + 1].value;
bmsp := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 46);
alphaSD := par[npar + 1].value;
Wrmin := par[npar + 2].value;
Wropt := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 60);
Jdharvest := par[npar + 1].value;
gammaH := par[npar + 2].value;
 
npar:=ParCount(ModelDef.numstate + 62);
for jj := 1 to 4 do z[jj] := par[npar + 1 + (jj - 1)*3].value;
for jj := 1 to 4 do rhos[jj] := par[npar + 2 + (jj - 1)*3].value;
for jj := 1 to 4 do thetas[jj] := par[npar + 3 + (jj - 1)*3].value;
 
npar:=ParCount(ModelDef.numstate + 66);
epsilonC := par[npar + 1].value;
epsilonN := par[npar + 2].value;
phi := par[npar + 3].value;
 
npar:=ParCount(ModelDef.numstate + 75);
for jj := 1 to 4 do psi[jj] := par[npar + 1 + (jj - 1)*5].value;
for jj := 1 to 4 do alphaNH4[jj] := par[npar + 2 + (jj - 1)*5].value;
for jj := 1 to 4 do alphaNO3[jj] := par[npar + 3 + (jj - 1)*5].value;
for jj := 1 to 4 do knh4m[jj] := par[npar + 4 + (jj - 1)*5].value;
for jj := 1 to 4 do kno3m[jj] := par[npar + 5 + (jj - 1)*5].value;
 
npar:=ParCount(ModelDef.numstate + 99);
for jj := 1 to 4 do Vnh4smax[jj] := par[npar + 1 + (jj - 1)*2].value;
for jj := 1 to 4 do etaenh4[jj] := par[npar + 2 + (jj - 1)*2].value;
 
npar:=ParCount(ModelDef.numstate + 111);
for jj := 1 to 4 do alphaDOC[jj] := par[npar + 1 + (jj - 1)*4].value;
for jj := 1 to 4 do Vdocsmax[jj] := par[npar + 2 + (jj - 1)*4].value;
for jj := 1 to 4 do etaDoc[jj] := par[npar + 3 + (jj - 1)*4].value;
for jj := 1 to 4 do qDOM[jj] := par[npar + 4 + (jj - 1)*4].value;
 
npar:=ParCount(ModelDef.numstate + 202);
gammaNitr := par[npar + 1].value;
knh4Nitr := par[npar + 2].value;
lambdaMax := par[npar + 3].value;
lambdaOpt := par[npar + 4].value;
lambdaMin := par[npar + 5].value;
dnitr := par[npar + 6].value;
Tnitmax := par[npar + 7].value;
Tnitopt := par[npar + 8].value;
anitr := par[npar + 9].value;
bnitr := par[npar + 10].value;
 
npar:=ParCount(ModelDef.numstate + 203);
for jj := 1 to 4 do gammaDenit[jj] := par[npar + 1 + (jj - 1)*1].value;
 
npar:=ParCount(ModelDef.numstate + 207);
aFno3 := par[npar + 1].value;
bFno3 := par[npar + 2].value;
aFco2 := par[npar + 3].value;
bFco2 := par[npar + 4].value;
aFh2o := par[npar + 5].value;
bFh2o := par[npar + 6].value;
cFh2o := par[npar + 7].value;
dFh2o := par[npar + 8].value;
eFh2o := par[npar + 9].value;
 
 
{ Enter the equations to calculate the processes here, using the local variable
  names defined above. }

Dum := 0;
For j := 1 to 4 do Dum2[j] := 0;
Dum3 := 0;
Dum4 := 0;
Dum5 := 0;
Dum6 := 0;
Dum7 := 0;

// Driver updates
(* The variables Rnh4e, Rno3e, Rdoce, and Rdone are the external supply rates. They are the
   array forms of Rnh4ee, Rno3ee, Rdocee, and Rdonee to be compatible with the derivatives. I've 
   assumed that only the top soil layer receives external inputs. *)
for j := 1 to 4 do
 begin
   Rnh4ee[j] := 0;
   Rno3ee[j] := 0;
   Rdocee[j] := 0;
   Rdonee[j] := 0;
 end;
Rnh4ee[1] := Rnh4e;
Rno3ee[1] := Rno3e;
Rdocee[1] := Rdoce;
Rdonee[1] := Rdone;

// Temperature 
Ta := (Tamax + Tamin)/2;

// Vegetation
Ba := Bamax*c*Bc/(Bamax + c*Bc);
q := Bc*qmin*qmax/(Ba*qmax + (Bc - Ba)*qmin);
If (Dday>=Ddbud) and (Jday <= Jddstart) then
  fc := min(1, fcmin + (1 - fcmin)*(Dday - Ddbud)/(Ddfull - Ddbud))
else if (Jday >= Jddstart) and (Jday <= Jddend) then
  fc := fcmin + (1 - fcmin)*(Jddend - Jday)/( Jddend - Jddstart)
else
  fc := fcmin;
Sc := bbc*Vc*fc*Ba;
Sn := bbn*Vn*Ba;
// Photosynthesis and N uptake
Msp := 1/(1+power(Wr[1]/Ww, bmsp));
For j := 1 to 4 do
 Begin
  If Wr[j] <> 0 then
   Begin
     dum := (Enh4[j] - rhos[j]*z[j]*Vnh4smax[j])/(1.4E-5*Wr[j]) - etaEnh4[j];
     Enh4aq[j] := 0.5*(dum + sqrt(power(dum,2) + 4*etaEnh4[j]*Enh4[j]/(1.4E-5*Wr[j])));
     Eno3aq[j] := Eno3[j]/(1.4e-5*Wr[j]);
   End
  else
   Begin
     Enh4aq[j] := 0;
     Eno3aq[j] := 0;
   End;
 End;
ggc := ggc*power(Q10gc, Ta/10)*Msp;
ggnh4 := ggnh4*power(Q10gn, Ta/10);
ggno3 := ggno3*power(Q10gn, Ta/10);
Gc := ggc*Ec/(kc + Ec);
If Enh4aq[1] = 0 then 
  Gnh4 := 0
else
  Gnh4 := ggnh4*Enh4aq[1]/(knh4 + Enh4aq[1]);
if Eno3aq[1] = 0 then
  Gno3 := 0
Else
  Gno3 := ggno3*Eno3aq[1]/(kno3 + Eno3aq[1]);
Ucv := Gc*Io*(1-exp(-ki*Sc));
Unh4v[1] := Gnh4*(1-exp(-ks*Sn));
Uno3v[1] := Gno3*(1-exp(-ks*Sn));
For j := 2 to 4 do
 Begin
  Unh4v[j] := 0;
  Uno3v[j] := 0;
 End;
Unv := Unh4v[1] + Uno3v[1];
// N fixation, currently not working
Rnup := 0;
{ (*if (Dday>=Ddfull) and (Jday<Jddstart) then 
 begin
  RNup := Gc*bbc*ki*Io*exp(ks*Sn-ki*Sc)/(Gn*bbn*ks);
  SwNfix := 1;
 End
Else
 begin
  RNup := mrNup;
  SwNfix := 0;
 End;
gnfix := gnfix*power(Q10Nfix, Ta/10);
If mrNup > rNfix then 
  Unfix := gnfix*Sn*(mrNup - rNfix)/(knfix + (mrNup - rNfix)) 
else   *)   }
  Unfix := 0;
// Respiration
ra := ra*power(Q10ra, Ta/10);
rw := rw*power(Q10rw, Ta/10);
Rcva := ra*Ba;
Rcvw := rw*(Bc - Ba);
Rcv := Rcva + Rcvw + Unfix*rnfix;
// Litterfall
Swle :=1/((1+exp(-betaSle*(Jday-Jdestart)))* (1+exp(betaSle*(Jday-Jdeend))));
Swld :=1/((1+exp(-betaSld*(Jday-Jddstart)))* (1+exp(betaSld*(Jday-Jddend))));
Swlr :=1/((1+exp(-betaSlr*(Jday-Jdrstart)))* (1+exp(betaSlr*(Jday-Jdrend))));
Swlw :=1/((1+exp(-betaSlw*(Jday-Jdwstart)))* (1+exp(betaSlw*(Jday-Jdwend))));
Lcve := Swle*ma*Vc*fcmin*Ba;
Lcvd := Swld*(Vc*Ba*(1-fcmin))/(Jddend-Jddstart);
Lcvr := Swlr*ma*Vn*Ba;
Lcvw := Swlw*mw*(Bc - Ba);
Lcvf := Lcve + Lcvd;
Lcva := Lcvf + Lcvr;
Lnve := (q*Bn/Bc)*(Lcve/qa);
Lnvd := (q*Bn/Bc)*(Lcvd/qa);
Lnvr := (q*Bn/Bc)*(Lcvr/qa);
Lnvw := (q*Bn/Bc)*(Lcvw/qw);
Lnvf := Lnve + Lnvd;
Lnva := Lnvf + Lnvr;
Lcv[1] := Lcve + Lcvd + Lcvr + Lcvw;
Lnv[1] := Lnve + Lnvd + Lnvr + Lnvw;
For j := 2 to 4 do
 Begin
  Lcv[j] := 0;
  Lnv[j] := 0;
 End;
Hcv := 0; // Discrete process
Hnv := Hcv*Bn/Bc;

// Soil
Theta := epsilonN*phi/epsilonC;
For j := 1 to 4 do
 Begin
   Msd[j] := 1-power(Wr[j]-Wrmin-Wropt,2)/(alphaSD*Wropt*(Wr[j]-Wrmin)+Wropt*Wropt);
   If Msd[j] < 0 then Msd[j] := 0;
   Psi[j] := psi[j]*Msd[j]*power(Q10d, Ta/10);
   If Enh4aq[j] = 0 then
     Unh4m[j] := 0
   Else
     Unh4m[j] := psi[j]*alphaNh4[j]*Dc[j]*Dc[j]*Enh4aq[j]/(theta*Dn[j]*(kNh4m[j]+Enh4aq[j]));
   if Eno3aq[j] = 0 then
     Uno3m[j] := 0
   else
     Uno3m[j] := psi[j]*alphaNo3[j]*Dc[j]*Dc[j]*Eno3aq[j]/(theta*Dn[j]*(kNo3m[j]+Eno3aq[j]));
   UNm[j] := Unh4m[j] + Uno3m[j];
   Mn[j] := psi[j]*Dn[j] + UNm[j];
   If (Dc[j] <> 0) and (psi[j] <> 0) then
    begin
      lambdaC[j] := epsilonC*theta*Mn[j]/(psi[j]*Dc[j]+theta*Mn[j]);
      lambdaN[j] := epsilonN*psi[j]*Dc[j]/(psi[j]*Dc[j]+theta*Mn[j]);
    end
   else
    begin
      lambdaC[j] := 0;
      lambdaN[j] := 0;
    end;
   Rcm[j] := psi[j]*Dc[j]*(1-lambdaC[j]);
   Rnm[j] := Mn[j]*(1-lambdaN[j]);
   Nnmin[j] := Rnm[j] - Unm[j];

// Nitrification and Denitrification
   if z[j] = 0 then
    begin
      dum := 0;
      dum3 := 0;
    end
   else
    begin
      dum := (Wr[j]/(1000*z[j]*thetas[j]) - lambdaMax)/(lambdaOpt - lambdaMax);
      dum3 := (Wr[j]/(1000*z[j]*thetas[j]) - lambdaMin)/(lambdaOpt - lambdaMin);
    end;
   Msnitr[j] := power(dum, dnitr*(lambdaMax-lambdaOpt)/(lambdaOpt-lambdaMin))*power(dum3, dnitr);
   Tnitr[j] := exp((anitr/bnitr)*(1-power((Tnitmax-Ta)/(Tnitmax-Tnitopt), bnitr)));
   Tnitr[j] := power((Tnitmax-Ta)/(Tnitmax-Tnitopt), anitr)*Tnitr[j];
   If Enh4aq[j] <> 0 then
     Lnitr[j] := gammaNitr*Msnitr[j]*Tnitr[j]*Enh4aq[j]/(knh4nitr + Enh4aq[j])
   Else
     Lnitr[j] := 0;
   If (gammaDenit[j] <> 0) and (Eno3[j]>0) then
    begin
     dum := Wr[j]/(thetas[j]*z[j]*10(*to convert z to mm, canceled with 100 (to convert to %) in numerator*));
     Ldenit[j] := min(aFno3*power(Eno3[j], bFno3), aFco2*power(Rcm[j], bFco2));
     Ldenit[j] := Ldenit[j]*(aFh2o + arctan(bFh2o*(cFh2o*dum-dFh2o))/eFh2o);
    End
   Else Ldenit[j] := 0;

// DOC & DON
   if (Wr[j] <> 0) and (qDOM[j] <> 0) then
    begin
     dum := (alphaDOC[j]*Dc[j] - rhos[j]*z[j]*Vdocsmax[j])/(1.2E-5*Wr[j]) - etaDOC[j];
     Docaq[j]:= 0.5*(dum + sqrt(power(dum,2) + 4*etaDOC[j]*alphaDOC[j]*Dc[j]/(1.2E-5*Wr[j])));
     Donaq[j]:= Docaq[j]/qDOM[j];
    End
   Else
    Begin
     Docaq[j]:= 0;
     Donaq[j]:= 0;
    End;
   Ldocd[j] := 1.2E-5*Drd[j]*Docaq[j];
   Ldond[j] := 1.4E-5*Drd[j]*Donaq[j];
   Ldocc[j] := 1.2E-5*Drc[j]*Docaq[j];
   Ldonc[j] := 1.4E-5*Drc[j]*Donaq[j];
   Ldocl[j] := 1.2E-5*Drl[j]*Docaq[j];
   Ldonl[j] := 1.4E-5*Drl[j]*Donaq[j];
   Ldoc[j] := Ldocc[j] + Ldocd[j] + Ldocl[j];
   Ldon[j] := Ldonc[j] + Ldond[j] + Ldonl[j];

// Soil Inorganic N losses
   Lnh4d[j] := 1.4E-5*Enh4aq[j]*Drd[j];
   Lno3d[j] := 1.4E-5*Eno3aq[j]*Drd[j];
   Lnh4c[j] := 1.4E-5*Enh4aq[j]*Drc[j];
   Lno3c[j] := 1.4E-5*Eno3aq[j]*Drc[j];
   Lnh4l[j] := 1.4E-5*Enh4aq[j]*Drl[j];
   Lno3l[j] := 1.4E-5*Eno3aq[j]*Drl[j];
   Lnh4[j] := Lnh4d[j] + Lnh4c[j] + Lnh4l[j];
   Lno3[j] := Lno3d[j] + Lno3c[j] + Lno3l[j];
   Lndin[j] := Lnh4d[j] + Lnh4c[j] + Lnh4l[j] + Lno3d[j] + Lno3c[j] + Lno3l[j];
 End;

(* The equations below are so that the for loops over the soil layers work properly. There really isn't
   a layer 0. These lines produce an error when the code compiles. To fix the error, change the array 
   declarations for Lnh4l, Lno3l, Ldocl, and Ldonl to read array[0..4] instead of array[1..4] (near line
   3583). This change must be done within Delphi, not in the Word table because CrEquations creates all arrays
   as 1 based. *)
Lnh4l[0] := 0;
Lno3l[0] := 0;
Ldocl[0] := 0;
Ldonl[0] := 0;


// Summary N loss terms
Lnd := Lnh4d[1] + Lnh4d[2] + Lnh4d[3] + Lnh4d[4] + Lno3d[1] + Lno3d[2] + Lno3d[3] + Lno3d[4];
Lnd := Lnd + Ldond[1] + Ldond[2] + Ldond[3] + Ldond[4];
Lnc := Lnh4c[1] + Lnh4c[2] + Lnh4c[3] + Lnh4c[4] + Lno3c[1] + Lno3c[2] + Lno3c[3] + Lno3c[4];
Lnc := Lnc + Ldonc[1] + Ldonc[2] + Ldonc[3] + Ldonc[4];
Lnt := Lnd + Lnc + Ldenit[1] + Ldenit[2] + Ldenit[3] + Ldenit[4];

// Acclimation
dBcdt := UCv - RCv - LCv[1];
dBndt := UNv - LNv[1] + Unfix;
A := ln(Bc/(q*Bn)) + h*(dBcdt/Bc - dBndt/Bn);
If A > 0 then
  DVcdt := -aa*A*Vc
Else
  DVcdt := -aa*A*Vn;

// Summaries
Qveg := Bc/Bn;
Qsoil := (Dc[1] + Dc[2] + Dc[3] + Dc[4])/(Dn[1] + Dn[2] + Dn[3] + Dn[4]);
NPP := Ucv-Rcv;
NEP := NPP - Rcm[1] - Rcm[2] - Rcm[3] - Rcm[4];
Ect := Bc + Dc[1] + Dc[2] + Dc[3] + Dc[4];
Ent := Bn + Dn[1] + Dn[2] + Dn[3] + Dn[4] + Enh4[1] + Enh4[2] + Enh4[3] + Enh4[4];
Ent := Ent + Eno3[1] + Eno3[2] + Eno3[3] + Eno3[4];

If CalculateDiscrete then
 Begin
   if Jday = 365 then dJdaydt := -Jday else dJdaydt := 1;
   if Jday < Jdegstart then dDdaydt := -Dday else
     if Ta > 0 then  dDdaydt := Ta
     else dDdaydt := 0;
   Jday := Jday + dJdaydt;
   Dday := Dday + dDdaydt;
   If (Jday = Jdharvest) then Hcv := gammaH*Bc else Hcv := 0;
   Hnv := Hcv*Bn/Bc;
   Bc := Bc - Hcv;
   Bn := Bn - Hnv;
 End;
if CalculateDiscrete then
begin
// Add any discrete processes here
end; //discrete processes


{ Now calculate the derivatives of the state variables. If the holdConstant
  portion of the state variable is set to true then set the derivative equal to
  zero. }
for jj := 1 to 4 do
begin
 if (tstat[0 + jj].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
  dEnh4dt[jj] := 0
 else
  dEnh4dt[jj] := Rnh4ee[jj]+Rnh4u[jj]+RNm[jj]+Lnh4l[jj-1]-Lnh4d[jj]-Lnh4c[jj]-Lnh4l[jj]-Unh4m[jj]-Unh4v[jj]-Lnitr[jj]; (* See note at the end of the equations section. *)
end;
 
for jj := 1 to 4 do
begin
 if (tstat[4 + jj].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
  dEno3dt[jj] := 0
 else
  dEno3dt[jj] := Rno3ee[jj]+Rno3u[jj]+Lnitr[jj]+Lno3l[jj-1]-Lno3d[jj]-Lno3c[jj]-Lno3l[jj]-Uno3m[jj]-Uno3v[jj]-Ldenit[jj];
end;
 
if (tstat[9].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dBcdt := 0
else
 dBcdt := dBcdt;
 
if (tstat[10].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dBndt := 0
else
 dBndt := dBndt;
 
for jj := 1 to 4 do
begin
 if (tstat[10 + jj].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
  dDcdt[jj] := 0
 else
  dDcdt[jj] := Rdocee[jj] + Rdocu[jj] + LCv[jj] + Ldocl[jj-1] - Rcm[jj] - Ldocd[jj] - Ldocc[jj] - Ldocl[jj];
end;
 
for jj := 1 to 4 do
begin
 if (tstat[14 + jj].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
  dDndt[jj] := 0
 else
  dDndt[jj] := Rdonee[jj] + Rdonu[jj] + LNv[jj] + UNm[jj] + Ldonl[jj-1] - RNm[jj] - Ldond[jj] - Ldonc[jj] - Ldonl[jj];
end;
 
if (tstat[19].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dVcdt := 0
else
 dVcdt := dVcdt;
 
if (tstat[20].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dVndt := 0
else
 dVndt := -dVcdt;
 
if (tstat[21].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dmrNupdt := 0
else
 dmrNupdt := tau*(rNup-mrNup);
 
if (tstat[22].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dJdaydt := 0
else
 dJdaydt := 0;   // Discrete process, derivative calculated in CalculateDiscrete section of equations
 
if (tstat[23].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dDdaydt := 0
else
 dDdaydt := 0;   // Discrete process, derivative calculated in CalculateDiscrete section of equations
 
if (tstat[24].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUcvdt := 0
else
 dCumUcvdt := Ucv;
 
if (tstat[25].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRcvdt := 0
else
 dCumRcvdt := Rcv;
 
if (tstat[26].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRcvadt := 0
else
 dCumRcvadt := Rcva;
 
if (tstat[27].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRcvwdt := 0
else
 dCumRcvwdt := Rcvw;
 
if (tstat[28].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvdt := 0
else
 dCumLcvdt := Lcv[1] + Lcv[2] + Lcv[3] + Lcv[4];
 
if (tstat[29].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRNedt := 0
else
 dCumRNedt := Rnh4e + Rno3e;
 
if (tstat[30].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRnh4edt := 0
else
 dCumRnh4edt := Rnh4e;
 
if (tstat[31].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRno3edt := 0
else
 dCumRno3edt := Rno3e;
 
if (tstat[32].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRNdt := 0
else
 dCumRNdt := Rnh4e+Rno3e+Rdone+Rnh4u[1]+Rnh4u[2]+Rnh4u[3]+Rnh4u[4]+Rno3u[1]+Rno3u[2]+Rno3u[3]+Rno3u[4]+Rdonu[1]+Rdonu[2]+Rdonu[3]+Rdonu[4];
 
if (tstat[33].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvdt := 0
else
 dCumLnvdt := Lnv[1] + Lnv[2] + Lnv[3] + Lnv[4];
 
if (tstat[34].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUnh4vdt := 0
else
 dCumUnh4vdt := Unh4v[1] + Unh4v[2] + Unh4v[3] + Unh4v[4];
 
if (tstat[35].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUno3vdt := 0
else
 dCumUno3vdt := Uno3v[1] + Uno3v[2] + Uno3v[3] + Uno3v[4];
 
if (tstat[36].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUnvdt := 0
else
 dCumUnvdt := Unv;
 
if (tstat[37].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnh4ddt := 0
else
 dCumLnh4ddt := Lnh4d[1] + Lnh4d[2] + Lnh4d[3] + Lnh4d[4];
 
if (tstat[38].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLno3ddt := 0
else
 dCumLno3ddt := Lno3d[1] + Lno3d[2] + Lno3d[3] + Lno3d[4];
 
if (tstat[39].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnh4cdt := 0
else
 dCumLnh4cdt := Lnh4c[1] + Lnh4c[2] + Lnh4c[3] + Lnh4c[4];
 
if (tstat[40].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLno3cdt := 0
else
 dCumLno3cdt := Lno3c[1] + Lno3c[2] + Lno3c[3] + Lno3c[4];
 
if (tstat[41].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRnmdt := 0
else
 dCumRnmdt := Rnm[1] + Rnm[2] + Rnm[3] + Rnm[4];
 
if (tstat[42].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUnh4mdt := 0
else
 dCumUnh4mdt := Unh4m[1] + Unh4m[2] + Unh4m[3] + Unh4m[4];
 
if (tstat[43].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUno3mdt := 0
else
 dCumUno3mdt := Uno3m[1] + Uno3m[2] + Uno3m[3] + Uno3m[4];
 
if (tstat[44].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumUnmdt := 0
else
 dCumUnmdt := Unm[1] + Unm[2] + Unm[3] + Unm[4];
 
if (tstat[45].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumNNmindt := 0
else
 dCumNNmindt := Nnmin[1] + Nnmin[2] + Nnmin[3] + Nnmin[4];
 
if (tstat[46].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumRcmdt := 0
else
 dCumRcmdt := Rcm[1] + Rcm[2] + Rcm[3] + Rcm[4];
 
if (tstat[47].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumNfixdt := 0
else
 dCumNfixdt := Unfix;
 
if (tstat[48].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvedt := 0
else
 dCumLcvedt := Lcve;
 
if (tstat[49].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvddt := 0
else
 dCumLcvddt := Lcvd;
 
if (tstat[50].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvfdt := 0
else
 dCumLcvfdt := Lcvf;
 
if (tstat[51].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvrdt := 0
else
 dCumLcvrdt := Lcvr;
 
if (tstat[52].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvadt := 0
else
 dCumLcvadt := Lcva;
 
if (tstat[53].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLcvwdt := 0
else
 dCumLcvwdt := Lcvw;
 
if (tstat[54].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvedt := 0
else
 dCumLnvedt := Lnve;
 
if (tstat[55].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvddt := 0
else
 dCumLnvddt := Lnvd;
 
if (tstat[56].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvfdt := 0
else
 dCumLnvfdt := Lnvf;
 
if (tstat[57].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvrdt := 0
else
 dCumLnvrdt := Lnvr;
 
if (tstat[58].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvadt := 0
else
 dCumLnvadt := Lnva;
 
if (tstat[59].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnvwdt := 0
else
 dCumLnvwdt := Lnvw;
 
if (tstat[60].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdocddt := 0
else
 dCumLdocddt := Ldocd[1] + Ldocd[2] + Ldocd[3] + Ldocd[4];
 
if (tstat[61].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdonddt := 0
else
 dCumLdonddt := Ldond[1] + Ldond[2] + Ldond[3] + Ldond[4];
 
if (tstat[62].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdoccdt := 0
else
 dCumLdoccdt := Ldocc[1] + Ldocc[2] + Ldocc[3] + Ldocc[4];
 
if (tstat[63].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdoncdt := 0
else
 dCumLdoncdt := Ldonc[1] + Ldonc[2] + Ldonc[3] + Ldonc[4];
 
if (tstat[64].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdocdt := 0
else
 dCumLdocdt := Ldocd[1] + Ldocd[2] + Ldocd[3] + Ldocd[4]+ Ldocc[1] + Ldocc[2] + Ldocc[3] + Ldocc[4];
 
if (tstat[65].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdondt := 0
else
 dCumLdondt := Ldond[1] + Ldond[2] + Ldond[3] + Ldond[4]+ Ldonc[1] + Ldonc[2] + Ldonc[3] + Ldonc[4];
 
if (tstat[66].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnddt := 0
else
 dCumLnddt := Lnd;
 
if (tstat[67].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLncdt := 0
else
 dCumLncdt := Lnc;
 
if (tstat[68].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLntdt := 0
else
 dCumLntdt := Lnt;
 
if (tstat[69].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnitrdt := 0
else
 dCumLnitrdt := Lnitr[1] + Lnitr[2] + Lnitr[3] + Lnitr[4];
 
if (tstat[70].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLdenitdt := 0
else
 dCumLdenitdt := Ldenit[1] + Ldenit[2] + Ldenit[3] + Ldenit[4];
 
if (tstat[71].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumNPPdt := 0
else
 dCumNPPdt := NPP;
 
if (tstat[72].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumNEPdt := 0
else
 dCumNEPdt := NEP;
 
if (tstat[73].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLnh4dt := 0
else
 dCumLnh4dt := Lnh4c[1] + Lnh4c[2] + Lnh4c[3] + Lnh4c[4] + Lnh4d[1] + Lnh4d[2] + Lnh4d[3] + Lnh4d[4];
 
if (tstat[74].HoldConstant) and (FmOptions.RunOptions.HoldStatesConstant) then
 dCumLno3dt := 0
else
 dCumLno3dt := Lno3c[1] + Lno3c[2] + Lno3c[3] + Lno3c[4] + Lno3d[1] + Lno3d[2] + Lno3d[3] + Lno3d[4];
 

{ Now that the calculations are complete, assign everything back into the arrays
  so the rest of the code can access the values calculated here. (Local variables
  are destroyed at the end of the procedure).

  Put the state variables back into the global arrays in case the state variable
  was manually changed in this procedure (e.g. discrete state variables or steady state
  calculations).   }
for jj := 1 to 4 do tstat[0 + jj].value := Enh4[jj];
for jj := 1 to 4 do tstat[4 + jj].value := Eno3[jj];
tstat[9].value := Bc;
tstat[10].value := Bn;
for jj := 1 to 4 do tstat[10 + jj].value := Dc[jj];
for jj := 1 to 4 do tstat[14 + jj].value := Dn[jj];
tstat[19].value := Vc;
tstat[20].value := Vn;
tstat[21].value := mrNup;
tstat[22].value := Jday;
tstat[23].value := Dday;
tstat[24].value := CumUcv;
tstat[25].value := CumRcv;
tstat[26].value := CumRcva;
tstat[27].value := CumRcvw;
tstat[28].value := CumLcv;
tstat[29].value := CumRNe;
tstat[30].value := CumRnh4e;
tstat[31].value := CumRno3e;
tstat[32].value := CumRN;
tstat[33].value := CumLnv;
tstat[34].value := CumUnh4v;
tstat[35].value := CumUno3v;
tstat[36].value := CumUnv;
tstat[37].value := CumLnh4d;
tstat[38].value := CumLno3d;
tstat[39].value := CumLnh4c;
tstat[40].value := CumLno3c;
tstat[41].value := CumRnm;
tstat[42].value := CumUnh4m;
tstat[43].value := CumUno3m;
tstat[44].value := CumUnm;
tstat[45].value := CumNNmin;
tstat[46].value := CumRcm;
tstat[47].value := CumNfix;
tstat[48].value := CumLcve;
tstat[49].value := CumLcvd;
tstat[50].value := CumLcvf;
tstat[51].value := CumLcvr;
tstat[52].value := CumLcva;
tstat[53].value := CumLcvw;
tstat[54].value := CumLnve;
tstat[55].value := CumLnvd;
tstat[56].value := CumLnvf;
tstat[57].value := CumLnvr;
tstat[58].value := CumLnva;
tstat[59].value := CumLnvw;
tstat[60].value := CumLdocd;
tstat[61].value := CumLdond;
tstat[62].value := CumLdocc;
tstat[63].value := CumLdonc;
tstat[64].value := CumLdoc;
tstat[65].value := CumLdon;
tstat[66].value := CumLnd;
tstat[67].value := CumLnc;
tstat[68].value := CumLnt;
tstat[69].value := CumLnitr;
tstat[70].value := CumLdenit;
tstat[71].value := CumNPP;
tstat[72].value := CumNEP;
tstat[73].value := CumLnh4;
tstat[74].value := CumLno3;

{  Put all process values into process variable array. The first numstate
  processes are the derivatives of the state variables (Calculated above).}
for jj := 1 to 4 do tproc[0 + jj].value := dEnh4dt[jj];
for jj := 1 to 4 do tproc[4 + jj].value := dEno3dt[jj];
tproc[9].value := dBcdt;
tproc[10].value := dBndt;
for jj := 1 to 4 do tproc[10 + jj].value := dDcdt[jj];
for jj := 1 to 4 do tproc[14 + jj].value := dDndt[jj];
tproc[19].value := dVcdt;
tproc[20].value := dVndt;
tproc[21].value := dmrNupdt;
tproc[22].value := dJdaydt;
tproc[23].value := dDdaydt;
tproc[24].value := dCumUcvdt;
tproc[25].value := dCumRcvdt;
tproc[26].value := dCumRcvadt;
tproc[27].value := dCumRcvwdt;
tproc[28].value := dCumLcvdt;
tproc[29].value := dCumRNedt;
tproc[30].value := dCumRnh4edt;
tproc[31].value := dCumRno3edt;
tproc[32].value := dCumRNdt;
tproc[33].value := dCumLnvdt;
tproc[34].value := dCumUnh4vdt;
tproc[35].value := dCumUno3vdt;
tproc[36].value := dCumUnvdt;
tproc[37].value := dCumLnh4ddt;
tproc[38].value := dCumLno3ddt;
tproc[39].value := dCumLnh4cdt;
tproc[40].value := dCumLno3cdt;
tproc[41].value := dCumRnmdt;
tproc[42].value := dCumUnh4mdt;
tproc[43].value := dCumUno3mdt;
tproc[44].value := dCumUnmdt;
tproc[45].value := dCumNNmindt;
tproc[46].value := dCumRcmdt;
tproc[47].value := dCumNfixdt;
tproc[48].value := dCumLcvedt;
tproc[49].value := dCumLcvddt;
tproc[50].value := dCumLcvfdt;
tproc[51].value := dCumLcvrdt;
tproc[52].value := dCumLcvadt;
tproc[53].value := dCumLcvwdt;
tproc[54].value := dCumLnvedt;
tproc[55].value := dCumLnvddt;
tproc[56].value := dCumLnvfdt;
tproc[57].value := dCumLnvrdt;
tproc[58].value := dCumLnvadt;
tproc[59].value := dCumLnvwdt;
tproc[60].value := dCumLdocddt;
tproc[61].value := dCumLdonddt;
tproc[62].value := dCumLdoccdt;
tproc[63].value := dCumLdoncdt;
tproc[64].value := dCumLdocdt;
tproc[65].value := dCumLdondt;
tproc[66].value := dCumLnddt;
tproc[67].value := dCumLncdt;
tproc[68].value := dCumLntdt;
tproc[69].value := dCumLnitrdt;
tproc[70].value := dCumLdenitdt;
tproc[71].value := dCumNPPdt;
tproc[72].value := dCumNEPdt;
tproc[73].value := dCumLnh4dt;
tproc[74].value := dCumLno3dt;

{ Now the remaining processes. Be sure to number the processes the same here as
  you did in the procedure counts above. }
tproc[ModelDef.numstate + 1].value := Ta;
tproc[ModelDef.numstate + 2].value := fc;
tproc[ModelDef.numstate + 3].value := dum3;
tproc[ModelDef.numstate + 4].value := Ba;
tproc[ModelDef.numstate + 5].value := q;
tproc[ModelDef.numstate + 6].value := Sc;
tproc[ModelDef.numstate + 7].value := Sn;
tproc[ModelDef.numstate + 8].value := GC;
tproc[ModelDef.numstate + 9].value := Gnh4;
tproc[ModelDef.numstate + 10].value := Gno3;
tproc[ModelDef.numstate + 11].value := UCv;
for jj := 1 to 4 do tproc[ModelDef.numstate + 11 + jj].value := Unh4v[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 15 + jj].value := Uno3v[jj];
tproc[ModelDef.numstate + 20].value := UNv;
tproc[ModelDef.numstate + 21].value := rNup;
tproc[ModelDef.numstate + 22].value := Unfix;
tproc[ModelDef.numstate + 23].value := Swle;
tproc[ModelDef.numstate + 24].value := Swlr;
tproc[ModelDef.numstate + 25].value := Swld;
tproc[ModelDef.numstate + 26].value := Swlw;
tproc[ModelDef.numstate + 27].value := dum6;
for jj := 1 to 4 do tproc[ModelDef.numstate + 27 + jj].value := LCv[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 31 + jj].value := LNv[jj];
tproc[ModelDef.numstate + 36].value := RCv;
tproc[ModelDef.numstate + 37].value := RCva;
tproc[ModelDef.numstate + 38].value := RCvw;
tproc[ModelDef.numstate + 39].value := A;
tproc[ModelDef.numstate + 40].value := dum;
tproc[ModelDef.numstate + 41].value := Msp;
for jj := 1 to 4 do tproc[ModelDef.numstate + 41 + jj].value := Msd[jj];
tproc[ModelDef.numstate + 46].value := dum7;
tproc[ModelDef.numstate + 47].value := Lcve;
tproc[ModelDef.numstate + 48].value := Lcvd;
tproc[ModelDef.numstate + 49].value := Lcvf;
tproc[ModelDef.numstate + 50].value := Lcvr;
tproc[ModelDef.numstate + 51].value := Lcva;
tproc[ModelDef.numstate + 52].value := Lcvw;
tproc[ModelDef.numstate + 53].value := Lnve;
tproc[ModelDef.numstate + 54].value := Lnvd;
tproc[ModelDef.numstate + 55].value := Lnvf;
tproc[ModelDef.numstate + 56].value := Lnvr;
tproc[ModelDef.numstate + 57].value := Lnva;
tproc[ModelDef.numstate + 58].value := Lnvw;
tproc[ModelDef.numstate + 59].value := swNfix;
tproc[ModelDef.numstate + 60].value := Hcv;
tproc[ModelDef.numstate + 61].value := Hnv;
for jj := 1 to 4 do tproc[ModelDef.numstate + 61 + jj].value := dum2[jj];
tproc[ModelDef.numstate + 66].value := theta;
for jj := 1 to 4 do tproc[ModelDef.numstate + 66 + jj].value := Unh4m[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 70 + jj].value := Uno3m[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 74 + jj].value := UNm[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 78 + jj].value := Mn[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 82 + jj].value := LambdaC[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 86 + jj].value := LambdaN[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 90 + jj].value := Rcm[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 94 + jj].value := Rnm[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 98 + jj].value := Enh4aq[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 102 + jj].value := Eno3aq[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 106 + jj].value := Nnmin[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 110 + jj].value := Docaq[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 114 + jj].value := Donaq[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 118 + jj].value := Lnh4d[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 122 + jj].value := Lno3d[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 126 + jj].value := Lnh4c[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 130 + jj].value := Lno3c[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 134 + jj].value := Lnh4l[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 138 + jj].value := Lno3l[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 142 + jj].value := Lnh4[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 146 + jj].value := Lno3[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 150 + jj].value := Lndin[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 154 + jj].value := Ldocd[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 158 + jj].value := Ldond[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 162 + jj].value := Ldocc[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 166 + jj].value := Ldonc[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 170 + jj].value := Ldocl[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 174 + jj].value := Ldonl[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 178 + jj].value := Ldoc[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 182 + jj].value := Ldon[jj];
tproc[ModelDef.numstate + 187].value := Lnd;
tproc[ModelDef.numstate + 188].value := Lnc;
tproc[ModelDef.numstate + 189].value := Lnt;
for jj := 1 to 4 do tproc[ModelDef.numstate + 189 + jj].value := Msnitr[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 193 + jj].value := Tnitr[jj];
for jj := 1 to 4 do tproc[ModelDef.numstate + 197 + jj].value := Lnitr[jj];
tproc[ModelDef.numstate + 202].value := dum4;
for jj := 1 to 4 do tproc[ModelDef.numstate + 202 + jj].value := Ldenit[jj];
tproc[ModelDef.numstate + 207].value := dum5;
tproc[ModelDef.numstate + 208].value := qveg;
tproc[ModelDef.numstate + 209].value := qsoil;
tproc[ModelDef.numstate + 210].value := NPP;
tproc[ModelDef.numstate + 211].value := NEP;
tproc[ModelDef.numstate + 212].value := Ect;
tproc[ModelDef.numstate + 213].value := Ent;

end;  // End of processes procedure


       { Do not make any modifications to code below this line. }
{****************************************************************************}


{This function counts the parameters in all processes less than processnum.}
function ParCount(processnum:integer) : integer;
var
 NumberofParams, counter : integer;
begin
  NumberofParams := 0;
  for counter := ModelDef.numstate + 1 to processnum - 1 do
         NumberofParams := NumberofParams + proc[counter].parameters;
  ParCount := NumberofParams;
end; // end of parcount function

{ This procedure supplies the derivatives of the state variables to the
  integrator. Since the integrator deals only with the values of the variables
  and not there names, units or the state field HoldConstant, this procedure
  copies the state values into a temporary state array and copies the value of
  HoldConstant into the temporary state array and passes this temporary state
  array to the procedure processes. }
PROCEDURE derivs(t, drt:double; var tdrive:drivearray; var tpar:paramarray;
             var statevalue:yValueArray; VAR dydt:yValueArray);
var
   i:integer;
   tempproc:processarray;
   tempstate:statearray;
begin
   tempstate := stat;  // Copy names, units and HoldConstant to tempstate
  // Copy current values of state variables into tempstate
   for i := 1 to ModelDef.numstate do tempstate[i].value := statevalue[i];
  // Calculate the process values
   processes(t, drt, tdrive, tpar, tempstate, tempproc, false);
  // Put process values into dydt array to get passed back to the integrator.
   for i:= 1 to ModelDef.numstate do dydt[i]:=tempproc[i].value;
end;  // end of derivs procedure

end.
